/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.anti_reptile.rule;

import cn.keking.anti_reptile.config.AntiReptileProperties;
import cn.keking.anti_reptile.rule.AbstractRule;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;

public class IpRule
extends AbstractRule {
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private AntiReptileProperties properties;
    private static final String RATELIMITER_COUNT_PREFIX = "ratelimiter_request_count";
    private static final String RATELIMITER_EXPIRATIONTIME_PREFIX = "ratelimiter_expirationtime";
    private static final String RATELIMITER_HIT_CRAWLERSTRATEGY = "ratelimiter_hit_crawlerstrategy";

    @Override
    protected boolean doExecute(HttpServletRequest request, HttpServletResponse response) {
        String ipAddress = IpRule.getIpAddr(request);
        List<String> ignoreIpList = this.properties.getIpRule().getIgnoreIp();
        if (ignoreIpList != null && ignoreIpList.size() > 0) {
            for (String ignoreIp : ignoreIpList) {
                if (ignoreIp.endsWith("*")) {
                    ignoreIp = ignoreIp.substring(0, ignoreIp.length() - 1);
                }
                if (!ipAddress.startsWith(ignoreIp)) continue;
                return false;
            }
        }
        String requestUrl = request.getRequestURI();
        int expirationTime = this.properties.getIpRule().getExpirationTime();
        int requestMaxSize = this.properties.getIpRule().getRequestMaxSize();
        RAtomicLong rRequestCount = this.redissonClient.getAtomicLong(RATELIMITER_COUNT_PREFIX.concat(requestUrl).concat(ipAddress));
        RAtomicLong rExpirationTime = this.redissonClient.getAtomicLong(RATELIMITER_EXPIRATIONTIME_PREFIX.concat(requestUrl).concat(ipAddress));
        if (!rExpirationTime.isExists()) {
            rRequestCount.set(0L);
            rExpirationTime.set(0L);
            rExpirationTime.expire((long)expirationTime, TimeUnit.MILLISECONDS);
        } else {
            RMap rHitMap = this.redissonClient.getMap(RATELIMITER_HIT_CRAWLERSTRATEGY);
            if (rRequestCount.incrementAndGet() > (long)requestMaxSize || rHitMap.containsKey((Object)ipAddress)) {
                rExpirationTime.expire(10L, TimeUnit.DAYS);
                rHitMap.put((Object)ipAddress, (Object)requestUrl);
                System.out.println("Intercepted request, uri: " + requestUrl + ", ip\uff1a" + ipAddress + " request " + requestMaxSize + " times in " + expirationTime + " ms");
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset(HttpServletRequest request, String realRequestUri) {
        String ipAddress = IpRule.getIpAddr(request);
        String requestUrl = realRequestUri;
        int expirationTime = this.properties.getIpRule().getExpirationTime();
        RAtomicLong rRequestCount = this.redissonClient.getAtomicLong(RATELIMITER_COUNT_PREFIX.concat(requestUrl).concat(ipAddress));
        RAtomicLong rExpirationTime = this.redissonClient.getAtomicLong(RATELIMITER_EXPIRATIONTIME_PREFIX.concat(requestUrl).concat(ipAddress));
        rRequestCount.set(0L);
        rExpirationTime.set(0L);
        rExpirationTime.expire((long)expirationTime, TimeUnit.MILLISECONDS);
        RMap rHitMap = this.redissonClient.getMap(RATELIMITER_HIT_CRAWLERSTRATEGY);
        rHitMap.remove((Object)ipAddress);
    }

    private static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

