/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.anti_reptile.interceptor;

import cn.keking.anti_reptile.annotation.AntiReptile;
import cn.keking.anti_reptile.config.AntiReptileProperties;
import cn.keking.anti_reptile.module.VerifyImageDTO;
import cn.keking.anti_reptile.rule.RuleActuator;
import cn.keking.anti_reptile.util.CrosUtil;
import cn.keking.anti_reptile.util.VerifyImageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AntiReptileInterceptor
extends HandlerInterceptorAdapter {
    private String antiReptileForm;
    private RuleActuator actuator;
    private List<String> includeUrls;
    private boolean globalFilterMode;
    private VerifyImageUtil verifyImageUtil;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void init(ServletContext context) {
        ClassPathResource classPathResource = new ClassPathResource("verify/index.html");
        try {
            classPathResource.getInputStream();
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)classPathResource.getInputStream());
            this.antiReptileForm = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.out.println("\u53cd\u722c\u866b\u9a8c\u8bc1\u6a21\u677f\u52a0\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        assert (ctx != null);
        this.actuator = (RuleActuator)ctx.getBean(RuleActuator.class);
        this.verifyImageUtil = (VerifyImageUtil)ctx.getBean(VerifyImageUtil.class);
        this.includeUrls = ((AntiReptileProperties)ctx.getBean(AntiReptileProperties.class)).getIncludeUrls();
        this.globalFilterMode = ((AntiReptileProperties)ctx.getBean(AntiReptileProperties.class)).isGlobalFilterMode();
        if (this.includeUrls == null) {
            this.includeUrls = new ArrayList<String>();
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        if (!this.initialized.get()) {
            this.init(request.getServletContext());
            this.initialized.set(true);
        }
        try {
            handlerMethod = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            return true;
        }
        Method method = handlerMethod.getMethod();
        AntiReptile antiReptile = (AntiReptile)AnnotationUtils.findAnnotation((Method)method, AntiReptile.class);
        boolean isAntiReptileAnnotation = antiReptile != null;
        String requestUrl = request.getRequestURI();
        if (this.isIntercept(requestUrl, isAntiReptileAnnotation) && !this.actuator.isAllowed(request, response)) {
            CrosUtil.setCrosHeader(response);
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(509);
            VerifyImageDTO verifyImage = this.verifyImageUtil.generateVerifyImg();
            this.verifyImageUtil.saveVerifyCodeToRedis(verifyImage);
            String str1 = this.antiReptileForm.replace("verifyId_value", verifyImage.getVerifyId());
            String str2 = str1.replaceAll("verifyImg_value", verifyImage.getVerifyImgStr());
            String str3 = str2.replaceAll("realRequestUri_value", requestUrl);
            response.getWriter().write(str3);
            response.getWriter().close();
            return false;
        }
        return true;
    }

    public boolean isIntercept(String requestUrl, Boolean isAntiReptileAnnotation) {
        if (this.globalFilterMode || isAntiReptileAnnotation.booleanValue() || this.includeUrls.contains(requestUrl)) {
            return true;
        }
        for (String includeUrl : this.includeUrls) {
            if (!Pattern.matches(includeUrl, requestUrl)) continue;
            return true;
        }
        return false;
    }
}

