/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.anti_reptile.config;

import cn.keking.anti_reptile.ValidateFormService;
import cn.keking.anti_reptile.config.AntiReptileProperties;
import cn.keking.anti_reptile.config.RedissonAutoConfig;
import cn.keking.anti_reptile.config.WebMvcConfig;
import cn.keking.anti_reptile.interceptor.AntiReptileInterceptor;
import cn.keking.anti_reptile.rule.AntiReptileRule;
import cn.keking.anti_reptile.rule.IpRule;
import cn.keking.anti_reptile.rule.RuleActuator;
import cn.keking.anti_reptile.rule.UaRule;
import cn.keking.anti_reptile.servlet.RefreshFormServlet;
import cn.keking.anti_reptile.servlet.ValidateFormServlet;
import cn.keking.anti_reptile.util.VerifyImageUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={AntiReptileProperties.class})
@ConditionalOnProperty(prefix="anti.reptile.manager", value={"enabled"}, havingValue="true")
@Import(value={RedissonAutoConfig.class, WebMvcConfig.class})
public class AntiReptileAutoConfig {
    @Bean
    public ServletRegistrationBean validateFormServlet() {
        return new ServletRegistrationBean((Servlet)new ValidateFormServlet(), new String[]{"/kk-anti-reptile/validate"});
    }

    @Bean
    public ServletRegistrationBean refreshFormServlet() {
        return new ServletRegistrationBean((Servlet)new RefreshFormServlet(), new String[]{"/kk-anti-reptile/refresh"});
    }

    @Bean
    @ConditionalOnProperty(prefix="anti.reptile.manager.ip-rule", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public IpRule ipRule() {
        return new IpRule();
    }

    @Bean
    @ConditionalOnProperty(prefix="anti.reptile.manager.ua-rule", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public UaRule uaRule() {
        return new UaRule();
    }

    @Bean
    public VerifyImageUtil verifyImageUtil() {
        return new VerifyImageUtil();
    }

    @Bean
    public RuleActuator ruleActuator(List<AntiReptileRule> rules) {
        List<AntiReptileRule> antiReptileRules = rules.stream().sorted(Comparator.comparingInt(AntiReptileRule::getOrder)).collect(Collectors.toList());
        return new RuleActuator(antiReptileRules);
    }

    @Bean
    public ValidateFormService validateFormService() {
        return new ValidateFormService();
    }

    @Bean
    public AntiReptileInterceptor antiReptileInterceptor() {
        return new AntiReptileInterceptor();
    }
}

