/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.anti_reptile;

import cn.keking.anti_reptile.module.VerifyImageDTO;
import cn.keking.anti_reptile.module.VerifyImageVO;
import cn.keking.anti_reptile.rule.RuleActuator;
import cn.keking.anti_reptile.util.VerifyImageUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidateFormService {
    @Autowired
    private RuleActuator actuator;
    @Autowired
    private VerifyImageUtil verifyImageUtil;

    public String validate(HttpServletRequest request) throws UnsupportedEncodingException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object object : items) {
            FileItem fileItem = (FileItem)object;
            if (!fileItem.isFormField()) continue;
            params.put(fileItem.getFieldName(), fileItem.getString("UTF-8"));
        }
        String verifyId = (String)params.get("verifyId");
        String result = (String)params.get("result");
        String realRequestUri = (String)params.get("realRequestUri");
        String actualResult = this.verifyImageUtil.getVerifyCodeFromRedis(verifyId);
        if (actualResult != null && request != null && actualResult.equals(result.toLowerCase())) {
            this.actuator.reset(request, realRequestUri);
            return "{\"result\":true}";
        }
        return "{\"result\":false}";
    }

    public String refresh(HttpServletRequest request) {
        String verifyId = request.getParameter("verifyId");
        this.verifyImageUtil.deleteVerifyCodeFromRedis(verifyId);
        VerifyImageDTO verifyImage = this.verifyImageUtil.generateVerifyImg();
        this.verifyImageUtil.saveVerifyCodeToRedis(verifyImage);
        VerifyImageVO verifyImageVO = new VerifyImageVO();
        BeanUtils.copyProperties((Object)verifyImage, (Object)verifyImageVO);
        String result = "{\"verifyId\": \"" + verifyImageVO.getVerifyId() + "\",\"verifyImgStr\": \"" + verifyImageVO.getVerifyImgStr() + "\"}";
        return result;
    }
}

