/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NettyClientInitializer;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient
implements IHttpClient {
    private static Logger LOG = LoggerFactory.getLogger(NettyHttpClient.class);
    private String _authCode;
    private int _maxRetryTimes;
    private int _readTimeout;
    private Channel _channel;
    private Bootstrap b;
    private EventLoopGroup _workerGroup;
    private SslContext _sslCtx;

    public NettyHttpClient(String authCode, HttpProxy proxy, ClientConfig config) {
        this._maxRetryTimes = config.getMaxRetryTimes();
        this._readTimeout = config.getReadTimeout();
        String message = MessageFormat.format("Created instance with connectionTimeout {0}, readTimeout {1}, maxRetryTimes {2}, SSL Version {3}", config.getConnectionTimeout(), this._readTimeout, this._maxRetryTimes, config.getSSLVersion());
        LOG.info(message);
        this._authCode = authCode;
        try {
            this._sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            this._workerGroup = new NioEventLoopGroup();
            this.b = new Bootstrap();
            this.b.group(this._workerGroup);
            this.b.channel(NioSocketChannel.class);
            this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        catch (SSLException e) {
            e.printStackTrace();
        }
    }

    public void sendRequest(HttpMethod method, String content, URI uri, BaseCallback callback) {
        DefaultFullHttpRequest request;
        this.b = new Bootstrap();
        if (this.b.group() == null) {
            this.b.group(this._workerGroup);
        }
        this.b.channel(NioSocketChannel.class);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.handler((ChannelHandler)new NettyClientInitializer(this._sslCtx, callback, null));
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        this._channel = this.b.connect(uri.getHost(), port).syncUninterruptibly().channel();
        if (null != content) {
            ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8));
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), byteBuf);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
        } else {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
        }
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
        request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
        LOG.info("Sending request. " + request);
        LOG.info("Send body: " + content);
        this._channel.writeAndFlush((Object)request);
        try {
            this._channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        return this.sendGet(url, null);
    }

    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        try {
            return this.sendHttpRequest(HttpMethod.GET, url, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return wrapper;
        }
    }

    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        try {
            return this.sendHttpRequest(HttpMethod.PUT, url, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return wrapper;
        }
    }

    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        try {
            return this.sendHttpRequest(HttpMethod.POST, url, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return wrapper;
        }
    }

    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        return this.sendDelete(url, null);
    }

    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        try {
            return this.sendHttpRequest(HttpMethod.DELETE, url, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return wrapper;
        }
    }

    private ResponseWrapper sendHttpRequest(HttpMethod method, String url, String body) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        NettyClientInitializer initializer = new NettyClientInitializer(this._sslCtx, null, latch);
        this.b.handler((ChannelHandler)initializer);
        ResponseWrapper wrapper = new ResponseWrapper();
        URI uri = new URI(url);
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        try {
            DefaultFullHttpRequest request;
            ChannelFuture connect = this.b.connect(host, port);
            this._channel = connect.sync().channel();
            if (null != body) {
                ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])body.getBytes(CharsetUtil.UTF_8));
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), byteBuf);
                request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
            } else {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
            }
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
            request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
            request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
            connect.awaitUninterruptibly();
            LOG.info("Sending request. " + request);
            LOG.info("Send body: " + body);
            this._channel.writeAndFlush((Object)request);
            latch.await();
            wrapper = initializer.getResponse();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return wrapper;
    }

    public void send(ByteBuf body, HttpMethod method, URI uri) {
        DefaultFullHttpRequest request;
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        this._channel = this.b.connect(host, port).syncUninterruptibly().channel();
        if (null != body) {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath(), body);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        } else {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
        }
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        request.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this._authCode);
        request.headers().set("Content-Type", (Object)"application/json;charset=utf-8");
        LOG.info("Sending request. " + request);
        LOG.info("Send body: " + body);
        this._channel.writeAndFlush((Object)request);
    }

    public void close() {
        if (null != this._channel) {
            this._channel.closeFuture().syncUninterruptibly();
            this._workerGroup.shutdownGracefully();
            this._channel = null;
            this._workerGroup = null;
        }
        System.out.println("Finished request(s)");
    }

    public static interface BaseCallback {
        public void onSucceed(ResponseWrapper var1);
    }
}

