/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.upload;

import cn.jasonone.ueditor.storage.LocationFileStorage;
import cn.jasonone.ueditor.upload.Config;
import cn.jasonone.ueditor.upload.UeditorStorage;
import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager
implements IStorageManager,
Config {
    private static final Logger log = LoggerFactory.getLogger(StorageManager.class);
    public static final int BUFFER_SIZE = 8192;
    private static UeditorStorage upload;

    public StorageManager() {
        upload = new LocationFileStorage();
    }

    public StorageManager(UeditorStorage upload) {
        if (upload == null) {
            upload = new LocationFileStorage();
        } else {
            StorageManager.upload = upload;
        }
    }

    public State saveBinaryFile(byte[] data, String rootPath, String savePath) {
        File file = new File(rootPath, savePath);
        BaseState state = upload.validFile(savePath);
        log.trace("\u68c0\u6d4b\u76ee\u5f55[{}]\u662f\u5426\u62e5\u6709\u5199\u6743\u9650:{}", (Object)savePath, (Object)state.isSuccess());
        if (!state.isSuccess()) {
            return state;
        }
        try {
            upload.save(data, rootPath, savePath);
            log.trace("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f:{}", (Object)file.getAbsoluteFile());
        }
        catch (IOException ioe) {
            state = new BaseState(false, 4);
            state.putInfo("path", file.getAbsolutePath());
            state.putInfo("size", (long)data.length);
            state.putInfo("title", file.getName());
            log.error(state.toString(), (Throwable)ioe);
            return state;
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("url", PathFormat.format((String)savePath));
        state.putInfo("size", (long)data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    public State saveFileByInputStream(InputStream is, String rootPath, String savePath, long maxSize) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            if (tmpFile.length() > maxSize) {
                tmpFile.delete();
                return new BaseState(false, 1);
            }
            state = StorageManager.saveTmpFile(tmpFile, rootPath, savePath);
            state.putInfo("url", PathFormat.format((String)savePath));
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    public State saveFileByInputStream(InputStream is, String rootPath, String savePath) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        try {
            BufferedInputStream bis = new BufferedInputStream(is, 8192);
            byte[] dataBuf = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            state = StorageManager.saveTmpFile(tmpFile, rootPath, savePath);
            state.putInfo("url", PathFormat.format((String)savePath));
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static File getTmpFile() {
        File tmpDir = FileUtils.getTempDirectory();
        String tmpFileName = (Math.random() * 10000.0 + "").replace(".", "");
        return new File(tmpDir, tmpFileName);
    }

    private static State saveTmpFile(File tmpFile, String rootPath, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        state = upload.validFile(path);
        log.trace("\u68c0\u6d4b\u76ee\u5f55[{}]\u662f\u5426\u62e5\u6709\u5199\u6743\u9650:{}", (Object)path, (Object)state.isSuccess());
        if (!state.isSuccess()) {
            return state;
        }
        try {
            upload.save(tmpFile, rootPath, path);
            log.trace("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f:{}", (Object)targetFile.getAbsoluteFile());
        }
        catch (IOException e) {
            state = new BaseState(false, 4);
            state.putInfo("path", targetFile.getAbsolutePath());
            state.putInfo("size", tmpFile.length());
            state.putInfo("title", targetFile.getName());
            log.error(state.toString(), (Throwable)e);
            return state;
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    @Override
    public void setConfig(Map<String, Object> conf) {
        upload.setConfig(conf);
    }

    public static UeditorStorage getUpload() {
        return upload;
    }
}

