/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor;

import cn.jasonone.ueditor.exception.ConfigException;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Component
@Scope(value="singleton")
@ConfigurationProperties(value="ue")
@Primary
public class UeditorProperties {
    private static final Logger log = LoggerFactory.getLogger(UeditorProperties.class);
    private static final String CONFIG_FILE_NAME = "config.json";
    private static final String DEFAULT_SERVER_URL = "/ueditor/jsp/controller";
    private static final String DEFAULT_ROOT_PATH = "classpath:/static";
    private String rootPath = "classpath:/static";
    private String serverUrl = "/ueditor/jsp/controller";

    @PostConstruct
    public void init() {
        this.checkServerUrl();
        this.checkRootPath();
        this.checkConfig();
    }

    private void checkServerUrl() {
        if (StringUtils.isEmpty((Object)this.serverUrl)) {
            this.serverUrl = DEFAULT_SERVER_URL;
            log.warn("\u7edf\u4e00\u670d\u52a1\u63a5\u53e3\u540d\u79f0\u914d\u7f6e\u4e3a\u7a7a,\u542f\u7528\u9ed8\u8ba4\u914d\u7f6e[{}]", (Object)DEFAULT_SERVER_URL);
        }
    }

    private void checkConfig() {
        Path path = Paths.get((this.rootPath + this.serverUrl).replace("\\", "/"), new String[0]);
        path = path.getParent();
        if (!Files.exists(path = path.resolve(CONFIG_FILE_NAME), new LinkOption[0])) {
            log.error("\u627e\u4e0d\u5230\u540e\u7aef\u914d\u7f6e\u6587\u4ef6:{}", (Object)path);
            throw new ConfigException("\u627e\u4e0d\u5230\u540e\u7aef\u914d\u7f6e\u6587\u4ef6:" + path);
        }
    }

    private void checkRootPath() {
        if (StringUtils.isEmpty((Object)this.rootPath)) {
            this.rootPath = DEFAULT_ROOT_PATH;
        }
        log.warn("\u4e0a\u4f20\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u914d\u7f6e\u4e3a\u7a7a,\u542f\u7528\u9ed8\u8ba4\u914d\u7f6e[{}]", (Object)DEFAULT_ROOT_PATH);
        if (StringUtils.startsWithIgnoreCase((String)this.rootPath, (String)"classpath:")) {
            this.rootPath = this.rootPath.replace("\\", "/");
            String path = this.rootPath.substring(10);
            try {
                this.rootPath = path = ResourceUtils.getFile((String)"classpath:") + path;
            }
            catch (FileNotFoundException e) {
                log.error("\u4e0a\u4f20\u76ee\u5f55\u914d\u7f6e\u9519\u8bef:{}", (Object)this.rootPath);
                throw new ConfigException("\u4e0a\u4f20\u76ee\u5f55\u914d\u7f6e\u9519\u8bef:" + this.rootPath, e);
            }
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UeditorProperties)) {
            return false;
        }
        UeditorProperties other = (UeditorProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        return !(this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UeditorProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        return result;
    }

    public String toString() {
        return "UeditorProperties(rootPath=" + this.getRootPath() + ", serverUrl=" + this.getServerUrl() + ")";
    }
}

