/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor;

import cn.jasonone.ueditor.upload.StorageManager;
import cn.jasonone.ueditor.upload.UeditorStorage;
import com.baidu.ueditor.ConfigManager;
import com.baidu.ueditor.define.ActionMap;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.hunter.ImageHunter;
import com.baidu.ueditor.upload.Base64Uploader;
import com.baidu.ueditor.upload.BinaryUploader;
import com.baidu.ueditor.upload.IStorageManager;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActionEnter {
    private HttpServletRequest request = null;
    private String rootPath = null;
    private String contextPath = null;
    private String actionType = null;
    private ConfigManager configManager = null;
    private StorageManager storage;

    public ActionEnter(HttpServletRequest request, String rootPath) {
        this(new StorageManager(), request, rootPath, null);
    }

    public ActionEnter(HttpServletRequest request, String rootPath, String configPath) {
        this(new StorageManager(), request, rootPath, configPath);
    }

    public ActionEnter(StorageManager storage, HttpServletRequest request, String rootPath) {
        this(storage, request, rootPath, null);
    }

    public ActionEnter(StorageManager storage, HttpServletRequest request, String rootPath, String configPath) {
        this.storage = storage;
        this.request = request;
        this.rootPath = rootPath;
        this.actionType = request.getParameter("action");
        this.contextPath = request.getContextPath();
        if (configPath == null && (configPath = request.getParameter("configPath")) == null) {
            configPath = request.getRequestURI();
        }
        this.configManager = ConfigManager.getInstance((String)this.rootPath, (String)this.contextPath, (String)configPath);
    }

    public String exec() {
        String callbackName = this.request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                return new BaseState(false, 401).toJSONString();
            }
            return callbackName + "(" + this.invoke() + ");";
        }
        return this.invoke();
    }

    public String invoke() {
        if (this.actionType == null || !ActionMap.mapping.containsKey(this.actionType)) {
            return new BaseState(false, 101).toJSONString();
        }
        if (this.configManager == null || !this.configManager.valid()) {
            return new BaseState(false, 102).toJSONString();
        }
        State state = null;
        int actionCode = ActionMap.getType((String)this.actionType);
        Map conf = null;
        switch (actionCode) {
            case 0: {
                return this.configManager.getAllConfig().toString();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                conf = this.configManager.getConfig(actionCode);
                this.storage.setConfig(conf);
                String filedName = (String)conf.get("fieldName");
                if ("true".equals(conf.get("isBase64"))) {
                    state = new Base64Uploader((IStorageManager)this.storage).save(this.request.getParameter(filedName), conf);
                    break;
                }
                state = new BinaryUploader((IStorageManager)this.storage).save(this.request, conf);
                break;
            }
            case 5: {
                conf = this.configManager.getConfig(actionCode);
                this.storage.setConfig(conf);
                String[] list = this.request.getParameterValues((String)conf.get("fieldName"));
                state = new ImageHunter((IStorageManager)this.storage, conf).capture(list);
                break;
            }
            case 6: 
            case 7: {
                conf = this.configManager.getConfig(actionCode);
                UeditorStorage upload = StorageManager.getUpload();
                upload.setConfig(conf);
                int start = this.getStartIndex();
                state = upload.listFile(start);
            }
        }
        return state.toJSONString();
    }

    public int getStartIndex() {
        String start = this.request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }
}

