/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.AbstractExcelSaxReader;
import cn.hutool.poi.excel.sax.CellDataType;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class Excel07SaxReader
extends AbstractExcelSaxReader<Excel07SaxReader>
implements ContentHandler {
    private static final String C_ELEMENT = "c";
    private static final String ROW_ELEMENT = "row";
    private static final String R_ATTR = "r";
    private static final String S_ATTR_VALUE = "s";
    private static final String T_ATTR_VALUE = "t";
    private static final String RID_PREFIX = "rId";
    private SharedStringsTable sharedStringsTable;
    private int curRow;
    private int curCell;
    private final StringBuilder lastContent = new StringBuilder(64);
    private CellDataType cellDataType;
    private String curCoordinate;
    private String preCoordinate;
    private String maxCellCoordinate;
    private StylesTable stylesTable;
    private String numFmtString;
    private int sheetIndex;
    List<Object> rowCellList = new ArrayList<Object>();
    private RowHandler rowHandler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws POIException {
        try {
            return this.read(OPCPackage.open((File)file), rid);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws POIException {
        try {
            return this.read(OPCPackage.open((InputStream)in), rid);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws POIException {
        InputStream sheetInputStream = null;
        try {
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            try {
                this.stylesTable = xssfReader.getStylesTable();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sharedStringsTable = xssfReader.getSharedStringsTable();
            if (rid > -1) {
                this.sheetIndex = rid;
                sheetInputStream = xssfReader.getSheet(RID_PREFIX + (rid + 1));
                ExcelSaxUtil.readFrom(sheetInputStream, this);
            } else {
                this.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.curRow = 0;
                    ++this.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxUtil.readFrom(sheetInputStream, this);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            IoUtil.close(sheetInputStream);
            IoUtil.close((Closeable)opcPackage);
        }
        return this;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (C_ELEMENT.equals(localName)) {
            String tempCurCoordinate = attributes.getValue(R_ATTR);
            this.preCoordinate = this.preCoordinate == null ? String.valueOf('@') : this.curCoordinate;
            this.curCoordinate = tempCurCoordinate;
            this.setCellType(attributes);
        }
        this.lastContent.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String contentStr = StrUtil.trim((CharSequence)this.lastContent);
        if (C_ELEMENT.equals(localName)) {
            Object value = ExcelSaxUtil.getDataValue(this.cellDataType, contentStr, this.sharedStringsTable, this.numFmtString);
            this.fillBlankCell(this.preCoordinate, this.curCoordinate, false);
            this.rowCellList.add(this.curCell++, value);
        } else if (ROW_ELEMENT.equals(localName)) {
            if (this.curRow == 0) {
                this.maxCellCoordinate = this.curCoordinate;
            }
            if (this.maxCellCoordinate != null) {
                this.fillBlankCell(this.curCoordinate, this.maxCellCoordinate, true);
            }
            this.rowHandler.handle(this.sheetIndex, this.curRow, this.rowCellList);
            this.rowCellList = new ArrayList<Object>(this.curCell + 1);
            ++this.curRow;
            this.curCell = 0;
            this.curCoordinate = null;
            this.preCoordinate = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.lastContent.append(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    private void fillBlankCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            int len = ExcelSaxUtil.countNullCell(preCoordinate, curCoordinate);
            if (isEnd) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                this.rowCellList.add(this.curCell++, "");
            }
        }
    }

    private void setCellType(Attributes attribute) {
        String xfIndexStr;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(attribute.getValue(T_ATTR_VALUE));
        if (null != this.stylesTable && null != (xfIndexStr = attribute.getValue(S_ATTR_VALUE))) {
            int xfIndex = Integer.parseInt(xfIndexStr);
            XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(xfIndex);
            this.numFmtString = xssfCellStyle.getDataFormatString();
            short numFmtIndex = xssfCellStyle.getDataFormat();
            if (this.numFmtString == null) {
                this.numFmtString = BuiltinFormats.getBuiltinFormat((int)numFmtIndex);
            } else if (CellDataType.NUMBER == this.cellDataType && DateUtil.isADateFormat((int)numFmtIndex, (String)this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }
}

