/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter
extends Writer {
    private final int indentFactor;
    private final int indent;
    private final Writer writer;
    private final JSONConfig config;
    private boolean needSeparator;
    private boolean arrayMode;

    public static JSONWriter of(Writer writer, int indentFactor, int indent, JSONConfig config) {
        return new JSONWriter(writer, indentFactor, indent, config);
    }

    public JSONWriter(Writer writer, int indentFactor, int indent, JSONConfig config) {
        this.writer = writer;
        this.indentFactor = indentFactor;
        this.indent = indent;
        this.config = config;
    }

    public JSONWriter beginObj() {
        this.writeRaw('{');
        return this;
    }

    public JSONWriter beginArray() {
        this.writeRaw('[');
        this.arrayMode = true;
        return this;
    }

    public JSONWriter end() {
        this.writeLF().writeSpace(this.indent);
        this.writeRaw(this.arrayMode ? (char)']' : '}');
        this.flush();
        this.arrayMode = false;
        this.needSeparator = true;
        return this;
    }

    public JSONWriter writeKey(String key) {
        if (this.needSeparator) {
            this.writeRaw(',');
        }
        this.writeLF().writeSpace(this.indentFactor + this.indent);
        return this.writeRaw(JSONUtil.quote(key));
    }

    public JSONWriter writeValue(Object value) {
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeValueDirect(value);
    }

    public JSONWriter writeField(String key, Object value) {
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeKey(key).writeValueDirect(value);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private JSONWriter writeValueDirect(Object value) {
        if (this.arrayMode) {
            if (this.needSeparator) {
                this.writeRaw(',');
            }
            this.writeLF().writeSpace(this.indentFactor + this.indent);
        } else {
            this.writeRaw(':').writeSpace(1);
        }
        this.needSeparator = true;
        return this.writeObjValue(value);
    }

    private JSONWriter writeObjValue(Object value) {
        int indent = this.indentFactor + this.indent;
        if (value == null || value instanceof JSONNull) {
            this.writeRaw(JSONNull.NULL.toString());
        } else if (value instanceof JSON) {
            ((JSON)value).write(this.writer, this.indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject(value).write(this.writer, this.indentFactor, indent);
        } else if (value instanceof Iterable || value instanceof Iterator || ArrayUtil.isArray((Object)value)) {
            new JSONArray(value).write(this.writer, this.indentFactor, indent);
        } else if (value instanceof Number) {
            this.writeNumberValue((Number)value);
        } else if (value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor) {
            String format = null == this.config ? null : this.config.getDateFormat();
            this.writeRaw(JSONWriter.formatDate(value, format));
        } else if (value instanceof Boolean) {
            this.writeBooleanValue((Boolean)value);
        } else if (value instanceof JSONString) {
            this.writeJSONStringValue((JSONString)value);
        } else {
            this.writeStrValue(value.toString());
        }
        return this;
    }

    private void writeNumberValue(Number number) {
        boolean isStripTrailingZeros = null == this.config || this.config.isStripTrailingZeros();
        this.writeRaw(NumberUtil.toStr((Number)number, (boolean)isStripTrailingZeros));
    }

    private void writeBooleanValue(Boolean value) {
        this.writeRaw(value.toString());
    }

    private void writeJSONStringValue(JSONString jsonString) {
        String valueStr;
        try {
            valueStr = jsonString.toJSONString();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        if (null != valueStr) {
            this.writeRaw(valueStr);
        } else {
            this.writeStrValue(jsonString.toString());
        }
    }

    private void writeStrValue(String csq) {
        try {
            JSONUtil.quote(csq, this.writer);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    private void writeSpace(int count) {
        if (this.indentFactor > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeRaw(' ');
            }
        }
    }

    private JSONWriter writeLF() {
        if (this.indentFactor > 0) {
            this.writeRaw('\n');
        }
        return this;
    }

    private JSONWriter writeRaw(String csq) {
        try {
            this.writer.append(csq);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    private JSONWriter writeRaw(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    private static String formatDate(Object dateObj, String format) {
        long timeMillis;
        if (StrUtil.isNotBlank((CharSequence)format)) {
            String dateStr = dateObj instanceof TemporalAccessor ? TemporalAccessorUtil.format((TemporalAccessor)((TemporalAccessor)dateObj), (String)format) : DateUtil.format((Date)Convert.toDate((Object)dateObj), (String)format);
            if ("#sss".equals(format) || "#SSS".equals(format)) {
                return dateStr;
            }
            return JSONUtil.quote(dateStr);
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)((TemporalAccessor)dateObj));
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            throw new UnsupportedOperationException("Unsupported Date type: " + dateObj.getClass());
        }
        return String.valueOf(timeMillis);
    }
}

