/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.impl.CollectionConverter;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    protected static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value instanceof JSONNull) {
            writer.write("null");
        } else if (value instanceof JSON) {
            ((JSON)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject((Map)value).write(writer, indentFactor, indent);
        } else if (value instanceof Iterable || value instanceof Iterator || value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(NumberUtil.toStr((Number)((Number)value)));
        } else if (value instanceof Date) {
            writer.write(String.valueOf(((Date)value).getTime()));
        } else if (value instanceof Calendar) {
            writer.write(String.valueOf(((Calendar)value).getTimeInMillis()));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(o != null ? o.toString() : JSONUtil.quote(value.toString()));
        } else {
            JSONUtil.quote(value.toString(), writer);
        }
        return writer;
    }

    protected static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    protected static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber((Object)obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    protected static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)((Number)value));
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    protected static Object stringToValue(String string) {
        if (null == string || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    protected static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value) {
        String keyStr = Convert.toStr((Object)key);
        String[] path = StrUtil.split((CharSequence)keyStr, (CharSequence)".");
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject();
                target.put(segment, (Object)nextTarget);
            }
            target = nextTarget;
        }
        target.put(path[last], value);
        return jsonObject;
    }

    protected static <T> T toBean(final JSONObject jsonObject, T bean, final boolean ignoreError) {
        return (T)BeanUtil.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                Object value = jsonObject.get(key);
                if (null == value) {
                    value = jsonObject.get(StrUtil.toUnderlineCase((CharSequence)key));
                }
                return InternalJSONUtil.jsonConvert(valueType, value, ignoreError);
            }

            public boolean containsKey(String key) {
                if (jsonObject.containsKey(key)) {
                    return true;
                }
                return jsonObject.containsKey(StrUtil.toUnderlineCase((CharSequence)key));
            }
        }, (CopyOptions)CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }

    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass, boolean ignoreError) {
        Class<?> componentType = arrayClass.isArray() ? arrayClass.getComponentType() : arrayClass;
        int size = jsonArray.size();
        Object objArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(objArray, i, InternalJSONUtil.jsonConvert(componentType, jsonArray.get(i), ignoreError));
        }
        return objArray;
    }

    protected static Object jsonConvert(Type type, Object value, boolean ignoreError) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (value instanceof JSONNull) {
            return null;
        }
        Class rowType = TypeUtil.getClass((Type)type);
        if (null == rowType) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Can not know Class of Type {} !", (Object[])new Object[]{type}));
        }
        if (JSON.class.isAssignableFrom(rowType)) {
            return JSONUtil.parse(value);
        }
        Object targetValue = null;
        if (value instanceof JSONObject) {
            targetValue = ((JSONObject)value).toBean(type, ignoreError);
        } else if (value instanceof JSONArray) {
            targetValue = rowType.isArray() ? ((JSONArray)value).toArray(rowType, ignoreError) : new CollectionConverter(type, TypeUtil.getTypeArgument((Type)type)).convert(value, null);
        }
        if (null == targetValue) {
            try {
                targetValue = ConverterRegistry.getInstance().convert((Type)rowType, value);
            }
            catch (ConvertException e) {
                if (ignoreError) {
                    return null;
                }
                throw e;
            }
        }
        if (null == targetValue && !ignoreError) {
            if (value instanceof CharSequence && StrUtil.isBlank((CharSequence)((CharSequence)value))) {
                return null;
            }
            throw new ConvertException("Can not convert [{}] to type [{}]", new Object[]{value, rowType.getName()});
        }
        return targetValue;
    }
}

