/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.beetl.BeetlEngine;
import cn.hutool.extra.template.engine.enjoy.EnjoyEngine;
import cn.hutool.extra.template.engine.freemarker.FreemarkerEngine;
import cn.hutool.extra.template.engine.rythm.RythmEngine;
import cn.hutool.extra.template.engine.thymeleaf.ThymeleafEngine;
import cn.hutool.extra.template.engine.velocity.VelocityEngine;
import cn.hutool.log.StaticLog;

public class TemplateFactory {
    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        StaticLog.debug((String)"Use [{}] Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        try {
            return new BeetlEngine(config);
        }
        catch (NoClassDefFoundError e) {
            try {
                return new FreemarkerEngine(config);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    return new VelocityEngine(config);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        return new RythmEngine(config);
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            return new EnjoyEngine(config);
                        }
                        catch (NoClassDefFoundError e5) {
                            try {
                                return new ThymeleafEngine(config);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                throw new TemplateException("No template found ! Please add one of template jar to your project !");
                            }
                        }
                    }
                }
            }
        }
    }
}

