/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScaner {
    private String packageName;
    private String packageDirName;
    private String packagePath;
    private Filter<Class<?>> classFilter;
    private Charset charset;
    private boolean initialize;
    private Set<Class<?>> classes = new HashSet();

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, final Class<? extends Annotation> annotationClass) {
        return ClassScaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, final Class<?> superClass) {
        return ClassScaner.scanPackage(packageName, new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> clazz) {
                return superClass.isAssignableFrom(clazz) && !superClass.equals(clazz);
            }
        });
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScaner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScaner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return new ClassScaner(packageName, classFilter).scan();
    }

    public ClassScaner() {
        this(null);
    }

    public ClassScaner(String packageName) {
        this(packageName, null);
    }

    public ClassScaner(String packageName, Filter<Class<?>> classFilter) {
        this(packageName, classFilter, CharsetUtil.CHARSET_UTF_8);
    }

    public ClassScaner(String packageName, Filter<Class<?>> classFilter, Charset charset) {
        this.packageName = StrUtil.nullToEmpty(packageName);
        this.packageDirName = this.packageName.replace('.', File.separatorChar);
        this.packagePath = this.packageName.replace('.', '/');
        this.classFilter = classFilter;
        this.charset = charset;
    }

    public Set<Class<?>> scan() {
        for (URL url : ResourceUtil.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLUtil.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(URLUtil.getJarFile(url));
                }
            }
        }
        if (CollUtil.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassUtil.getJavaClassPaths()) {
            classPath = URLUtil.decode(classPath, CharsetUtil.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(this.loadClass(className));
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        } else if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
            String name = StrUtil.removePrefix(entry.getName(), "/");
            if (!name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            Console.log(name);
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    private Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, ClassUtil.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
        }
        catch (UnsupportedClassVersionError e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(Class<?> clazz) {
        Filter<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classFilter) == null || classFilter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StrUtil.isEmpty(this.packageDirName)) {
            return StrUtil.addSuffixIfNot(filePath, "/");
        }
        return StrUtil.subBefore(filePath, this.packageDirName, true);
    }
}

