/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.enhance.feign;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.engine.rest.client.enhance.feign.FeignRemoteCallExceptionWrapper;
import cn.herodotus.engine.rest.core.exception.FeignDecodeIOException;
import com.fasterxml.jackson.databind.JavaType;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        try {
            String content = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
            Result result = Result.failure((String)("Feign \u8fdc\u7a0b\u8c03\u7528" + methodKey + " \u51fa\u9519"));
            JavaType javaType = Jackson2Utils.getTypeFactory().constructParametricType(Result.class, new Class[]{String.class});
            Result object = (Result)Jackson2Utils.toObject((String)content, (JavaType)javaType);
            if (ObjectUtils.isEmpty((Object)object)) {
                result = object;
            }
            return new FeignRemoteCallExceptionWrapper((Result<String>)result);
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Feign invoke [{}] error decoder convert result catch io exception.", (Object)methodKey, (Object)e);
            return new FeignDecodeIOException();
        }
    }
}

