/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.filter;

import cn.dev33.satoken.exception.RequestPathInvalidException;
import cn.dev33.satoken.strategy.SaStrategy;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-1000)
public class SaPathCheckFilterForReactor
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        try {
            SaStrategy.instance.checkRequestPath.run(exchange.getRequest().getPath().toString(), (Object)exchange, null);
        }
        catch (RequestPathInvalidException e) {
            if (SaStrategy.instance.requestPathInvalidHandle == null) {
                exchange.getResponse().getHeaders().set("Content-Type", "text/plain; charset=utf-8");
                return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(e.getMessage().getBytes())));
            }
            SaStrategy.instance.requestPathInvalidHandle.run(e, (Object)exchange, null);
            return Mono.empty();
        }
        return chain.filter(exchange);
    }
}

