/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.convert;

import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.convert.SaOAuth2DataConverter;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaTtlMethods;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SaOAuth2DataConverterDefaultImpl
implements SaOAuth2DataConverter,
SaTtlMethods {
    @Override
    public List<String> convertScopeStringToList(String scopeString) {
        if (SaFoxUtil.isEmpty((Object)scopeString)) {
            return new ArrayList<String>();
        }
        scopeString = scopeString.replace(" ", ",");
        scopeString = scopeString.replace("%20", ",");
        scopeString = scopeString.replace("+", ",");
        return SaFoxUtil.convertStringToList((String)scopeString);
    }

    @Override
    public String convertScopeListToString(List<String> scopeList) {
        return SaFoxUtil.convertListToString(scopeList);
    }

    @Override
    public List<String> convertRedirectUriStringToList(String redirectUris) {
        if (SaFoxUtil.isEmpty((Object)redirectUris)) {
            return new ArrayList<String>();
        }
        return SaFoxUtil.convertStringToList((String)redirectUris);
    }

    @Override
    public CodeModel convertRequestAuthToCode(RequestAuthModel ra) {
        String codeValue = SaOAuth2Strategy.instance.createCodeValue.execute(ra.clientId, ra.loginId, ra.scopes);
        CodeModel cm = new CodeModel();
        cm.code = codeValue;
        cm.clientId = ra.clientId;
        cm.scopes = ra.scopes;
        cm.loginId = ra.loginId;
        cm.redirectUri = ra.redirectUri;
        cm.nonce = ra.getNonce();
        return cm;
    }

    @Override
    public AccessTokenModel convertRequestAuthToAccessToken(RequestAuthModel ra, long accessTokenTimeout) {
        String newAtValue = SaOAuth2Strategy.instance.createAccessToken.execute(ra.clientId, ra.loginId, ra.scopes);
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = newAtValue;
        at.clientId = ra.clientId;
        at.loginId = ra.loginId;
        at.scopes = ra.scopes;
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        at.expiresTime = this.ttlToExpireTime(accessTokenTimeout);
        at.extraData = new LinkedHashMap<String, Object>();
        return at;
    }

    @Override
    public AccessTokenModel convertCodeToAccessToken(CodeModel cm, long accessTokenTimeout) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = SaOAuth2Strategy.instance.createAccessToken.execute(cm.clientId, cm.loginId, cm.scopes);
        at.clientId = cm.clientId;
        at.loginId = cm.loginId;
        at.scopes = cm.scopes;
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        at.grantType = GrantType.authorization_code;
        at.expiresTime = this.ttlToExpireTime(accessTokenTimeout);
        at.extraData = new LinkedHashMap<String, Object>();
        return at;
    }

    @Override
    public RefreshTokenModel convertAccessTokenToRefreshToken(AccessTokenModel at, long refreshTokenTimeout) {
        RefreshTokenModel rt = new RefreshTokenModel();
        rt.refreshToken = SaOAuth2Strategy.instance.createRefreshToken.execute(at.clientId, at.loginId, at.scopes);
        rt.clientId = at.clientId;
        rt.loginId = at.loginId;
        rt.scopes = at.scopes;
        rt.expiresTime = this.ttlToExpireTime(refreshTokenTimeout);
        rt.extraData = new LinkedHashMap<String, Object>(at.extraData);
        return rt;
    }

    @Override
    public AccessTokenModel convertRefreshTokenToAccessToken(RefreshTokenModel rt, long accessTokenTimeout) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = SaOAuth2Strategy.instance.createAccessToken.execute(rt.clientId, rt.loginId, rt.scopes);
        at.refreshToken = rt.refreshToken;
        at.clientId = rt.clientId;
        at.loginId = rt.loginId;
        at.scopes = rt.scopes;
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        at.grantType = GrantType.refresh_token;
        at.extraData = new LinkedHashMap<String, Object>(rt.extraData);
        at.expiresTime = this.ttlToExpireTime(accessTokenTimeout);
        at.refreshExpiresTime = rt.expiresTime;
        return at;
    }

    @Override
    public RefreshTokenModel convertRefreshTokenToRefreshToken(RefreshTokenModel rt, long refreshTokenTimeout) {
        RefreshTokenModel newRt = new RefreshTokenModel();
        newRt.refreshToken = SaOAuth2Strategy.instance.createRefreshToken.execute(rt.clientId, rt.loginId, rt.scopes);
        newRt.expiresTime = this.ttlToExpireTime(refreshTokenTimeout);
        newRt.clientId = rt.clientId;
        newRt.scopes = rt.scopes;
        newRt.loginId = rt.loginId;
        newRt.extraData = new LinkedHashMap<String, Object>(rt.extraData);
        return newRt;
    }

    @Override
    public ClientTokenModel convertSaClientToClientToken(SaClientModel clientModel, List<String> scopes) {
        String clientTokenValue = SaOAuth2Strategy.instance.createClientToken.execute(clientModel.getClientId(), scopes);
        ClientTokenModel ct = new ClientTokenModel(clientTokenValue, clientModel.getClientId(), scopes);
        ct.clientToken = clientTokenValue;
        ct.clientId = clientModel.getClientId();
        ct.scopes = scopes;
        ct.tokenType = SaOAuth2Consts.TokenType.bearer;
        ct.expiresTime = this.ttlToExpireTime(clientModel.getClientTokenTimeout());
        ct.grantType = GrantType.client_credentials;
        ct.extraData = new LinkedHashMap<String, Object>();
        return ct;
    }
}

