/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.resolver;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.httpauth.basic.SaHttpBasicUtil;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.request.ClientIdAndSecretModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.data.resolver.SaOAuth2DataResolver;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaOAuth2DataResolverDefaultImpl
implements SaOAuth2DataResolver {
    @Override
    public ClientIdAndSecretModel readClientIdAndSecret(SaRequest request) {
        String clientId = request.getParam(SaOAuth2Consts.Param.client_id);
        String clientSecret = request.getParam(SaOAuth2Consts.Param.client_secret);
        if (SaFoxUtil.isNotEmpty((Object)clientId)) {
            return new ClientIdAndSecretModel(clientId, clientSecret);
        }
        String authorizationValue = SaHttpBasicUtil.getAuthorizationValue();
        if (SaFoxUtil.isNotEmpty((Object)authorizationValue)) {
            String[] arr = authorizationValue.split(":");
            clientId = arr[0];
            if (arr.length > 1) {
                clientSecret = arr[1];
            }
            return new ClientIdAndSecretModel(clientId, clientSecret);
        }
        throw new SaOAuth2Exception("\u8bf7\u63d0\u4f9b client \u4fe1\u606f").setCode(30191);
    }

    @Override
    public String readAccessToken(SaRequest request) {
        String accessToken = request.getParam(SaOAuth2Consts.Param.access_token);
        if (SaFoxUtil.isNotEmpty((Object)accessToken)) {
            return accessToken;
        }
        String authorizationValue = request.getHeader(SaOAuth2Consts.Param.Authorization);
        if (SaFoxUtil.isEmpty((Object)authorizationValue)) {
            return null;
        }
        String prefix = SaOAuth2Consts.TokenType.Bearer + " ";
        if (authorizationValue.startsWith(prefix)) {
            return authorizationValue.substring(prefix.length());
        }
        return null;
    }

    @Override
    public String readClientToken(SaRequest request) {
        String clientToken = request.getParam(SaOAuth2Consts.Param.client_token);
        if (SaFoxUtil.isNotEmpty((Object)clientToken)) {
            return clientToken;
        }
        String authorizationValue = request.getHeader(SaOAuth2Consts.Param.Authorization);
        if (SaFoxUtil.isEmpty((Object)authorizationValue)) {
            return null;
        }
        String prefix = SaOAuth2Consts.TokenType.Bearer + " ";
        if (authorizationValue.startsWith(prefix)) {
            return authorizationValue.substring(prefix.length());
        }
        return null;
    }

    @Override
    public RequestAuthModel readRequestAuthModel(SaRequest req, Object loginId) {
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        ra.responseType = req.getParamNotNull(SaOAuth2Consts.Param.response_type);
        ra.redirectUri = req.getParamNotNull(SaOAuth2Consts.Param.redirect_uri);
        ra.state = req.getParam(SaOAuth2Consts.Param.state);
        ra.nonce = req.getParam(SaOAuth2Consts.Param.nonce);
        ra.scopes = SaOAuth2Manager.getDataConverter().convertScopeStringToList(req.getParam(SaOAuth2Consts.Param.scope));
        ra.loginId = loginId;
        return ra;
    }

    @Override
    public Map<String, Object> buildAccessTokenReturnValue(AccessTokenModel at) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("token_type", at.tokenType);
        map.put("access_token", at.accessToken);
        map.put("refresh_token", at.refreshToken);
        map.put("expires_in", at.getExpiresIn());
        map.put("refresh_expires_in", at.getRefreshExpiresIn());
        map.put("client_id", at.clientId);
        map.put("scope", SaOAuth2Manager.getDataConverter().convertScopeListToString(at.scopes));
        map.putAll(at.extraData);
        SaResult result = SaResult.ok().setMap(map);
        if (SaOAuth2Manager.getServerConfig().hideStatusField.booleanValue()) {
            result.removeDefaultFields();
        }
        return result;
    }

    @Override
    public Map<String, Object> buildClientTokenReturnValue(ClientTokenModel ct) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("token_type", ct.tokenType);
        map.put("client_token", ct.clientToken);
        if (SaOAuth2Manager.getServerConfig().mode4ReturnAccessToken.booleanValue()) {
            map.put("access_token", ct.clientToken);
        }
        map.put("expires_in", ct.getExpiresIn());
        map.put("client_id", ct.clientId);
        map.put("scope", SaOAuth2Manager.getDataConverter().convertScopeListToString(ct.scopes));
        map.putAll(ct.extraData);
        SaResult result = SaResult.ok().setMap(map);
        if (SaOAuth2Manager.getServerConfig().hideStatusField.booleanValue()) {
            result.removeDefaultFields();
        }
        return result;
    }
}

