/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.model;

import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.config.SaOAuth2Config;
import java.io.Serializable;

public class SaClientModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String clientId;
    public String clientSecret;
    public String contractScope;
    public String allowUrl;
    public Boolean isCode = false;
    public Boolean isImplicit = false;
    public Boolean isPassword = false;
    public Boolean isClient = false;
    public Boolean isAutoMode = true;
    public Boolean isNewRefresh;
    public long accessTokenTimeout;
    public long refreshTokenTimeout;
    public long clientTokenTimeout;
    public long pastClientTokenTimeout;

    public SaClientModel() {
        SaOAuth2Config config = SaOAuth2Manager.getConfig();
        this.isNewRefresh = config.getIsNewRefresh();
        this.accessTokenTimeout = config.getAccessTokenTimeout();
        this.refreshTokenTimeout = config.getRefreshTokenTimeout();
        this.clientTokenTimeout = config.getClientTokenTimeout();
        this.pastClientTokenTimeout = config.getPastClientTokenTimeout();
    }

    public SaClientModel(String clientId, String clientSecret, String contractScope, String allowUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.contractScope = contractScope;
        this.allowUrl = allowUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SaClientModel setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SaClientModel setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getContractScope() {
        return this.contractScope;
    }

    public SaClientModel setContractScope(String contractScope) {
        this.contractScope = contractScope;
        return this;
    }

    public String getAllowUrl() {
        return this.allowUrl;
    }

    public SaClientModel setAllowUrl(String allowUrl) {
        this.allowUrl = allowUrl;
        return this;
    }

    public Boolean getIsCode() {
        return this.isCode;
    }

    public SaClientModel setIsCode(Boolean isCode) {
        this.isCode = isCode;
        return this;
    }

    public Boolean getIsImplicit() {
        return this.isImplicit;
    }

    public SaClientModel setIsImplicit(Boolean isImplicit) {
        this.isImplicit = isImplicit;
        return this;
    }

    public Boolean getIsPassword() {
        return this.isPassword;
    }

    public SaClientModel setIsPassword(Boolean isPassword) {
        this.isPassword = isPassword;
        return this;
    }

    public Boolean getIsClient() {
        return this.isClient;
    }

    public SaClientModel setIsClient(Boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    public Boolean getIsAutoMode() {
        return this.isAutoMode;
    }

    public SaClientModel setIsAutoMode(Boolean isAutoMode) {
        this.isAutoMode = isAutoMode;
        return this;
    }

    public Boolean getIsNewRefresh() {
        return this.isNewRefresh;
    }

    public SaClientModel setIsNewRefresh(Boolean isNewRefresh) {
        this.isNewRefresh = isNewRefresh;
        return this;
    }

    public long getAccessTokenTimeout() {
        return this.accessTokenTimeout;
    }

    public SaClientModel setAccessTokenTimeout(long accessTokenTimeout) {
        this.accessTokenTimeout = accessTokenTimeout;
        return this;
    }

    public long getRefreshTokenTimeout() {
        return this.refreshTokenTimeout;
    }

    public SaClientModel setRefreshTokenTimeout(long refreshTokenTimeout) {
        this.refreshTokenTimeout = refreshTokenTimeout;
        return this;
    }

    public long getClientTokenTimeout() {
        return this.clientTokenTimeout;
    }

    public SaClientModel setClientTokenTimeout(long clientTokenTimeout) {
        this.clientTokenTimeout = clientTokenTimeout;
        return this;
    }

    public long getPastClientTokenTimeout() {
        return this.pastClientTokenTimeout;
    }

    public SaClientModel setPastClientTokenTimeout(long pastClientTokenTimeout) {
        this.pastClientTokenTimeout = pastClientTokenTimeout;
        return this;
    }

    public String toString() {
        return "SaClientModel [clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", contractScope=" + this.contractScope + ", allowUrl=" + this.allowUrl + ", isCode=" + this.isCode + ", isImplicit=" + this.isImplicit + ", isPassword=" + this.isPassword + ", isClient=" + this.isClient + ", isAutoMode=" + this.isAutoMode + ", isNewRefresh=" + this.isNewRefresh + ", accessTokenTimeout=" + this.accessTokenTimeout + ", refreshTokenTimeout=" + this.refreshTokenTimeout + ", clientTokenTimeout=" + this.clientTokenTimeout + ", pastClientTokenTimeout=" + this.pastClientTokenTimeout + "]";
    }
}

