/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClientTokenModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String clientToken;
    public long expiresTime;
    public String clientId;
    public String scope;

    public ClientTokenModel() {
    }

    public ClientTokenModel(String accessToken, String clientId, String scope) {
        this.clientToken = accessToken;
        this.clientId = clientId;
        this.scope = scope;
    }

    public String toString() {
        return "ClientTokenModel [clientToken=" + this.clientToken + ", expiresTime=" + this.expiresTime + ", clientId=" + this.clientId + ", scope=" + this.scope + "]";
    }

    public long getExpiresIn() {
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public Map<String, Object> toLineMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("client_token", this.clientToken);
        map.put("expires_in", this.getExpiresIn());
        map.put("client_id", this.clientId);
        map.put("scope", this.scope);
        return map;
    }
}

