/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase;

import cn.com.vastbase.GlobalConnectionTracker;
import cn.com.vastbase.PGProperty;
import cn.com.vastbase.QueryCNListUtils;
import cn.com.vastbase.clusterchooser.GlobalClusterStatusTracker;
import cn.com.vastbase.hostchooser.MultiHostChooser;
import cn.com.vastbase.jdbc.PgConnection;
import cn.com.vastbase.log.Log;
import cn.com.vastbase.log.Logger;
import cn.com.vastbase.log.Tracer;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.HostSpec;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import cn.com.vastbase.util.SharedTimer;
import cn.com.vastbase.util.URLCoder;
import cn.com.vastbase.util.WriterHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;

public class Driver
implements java.sql.Driver {
    private static Driver registeredDriver;
    private static final java.util.logging.Logger PARENT_LOGGER;
    private static Log LOGGER;
    private static final SharedTimer sharedTimer;
    private static final String DEFAULT_PORT = "5432";
    private static final String gsVersion = "@GSVERSION@";
    public static AtomicBoolean isLogFileCreated;
    private static final String[] SENSITIVE_CHARACTERS;
    private static Tracer tracer;
    private static final AtomicBoolean tracerInitialized;
    private Properties defaultProperties;
    private static String loggerHandlerFile;

    public static String getTracer() {
        if (tracer == null) {
            return null;
        }
        String traceId = tracer.getTraceId();
        if (traceId == null) {
            return null;
        }
        if (traceId.length() > 32) {
            traceId = traceId.substring(0, 32);
            LOGGER.warn("When used link trace, the length of trace id should be less or equals than 32, currently truncated to " + traceId + ".");
        } else if (traceId.length() < 1) {
            LOGGER.warn("When used link trace, the length of trace id should be greater than 0.");
        }
        return traceId;
    }

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.debug("Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.warn("Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    public static Properties GetProps(Properties defaults, Properties info) throws PSQLException {
        Properties newProps = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                newProps.setProperty(propName, propValue);
            }
        }
        return newProps;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        String[] legalUrlTags = new String[]{"jdbc:vastbase:", "jdbc:dws:iam:"};
        boolean isUrlLegal = false;
        for (String urlTag : legalUrlTags) {
            if (!url.startsWith(urlTag)) continue;
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = Driver.GetProps(defaults, info);
        props = Driver.parseURL(url, props);
        if (props == null) {
            return null;
        }
        if (!this.parseConnectionProperties(props).booleanValue()) {
            return null;
        }
        try {
            LOGGER.debug("Connecting with URL: " + Driver.filterAuthenticationCredentials(url));
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                Connection con = Driver.makeConnection(url, props);
                return con;
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.debug("Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.debug("Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private Boolean parseConnectionProperties(Properties props) {
        Logger.setLoggerName(props.getProperty("logger"));
        if (Logger.isUsingJDKLogger()) {
            this.setupLoggerFromProperties(props);
        } else {
            LOGGER = Logger.getLogger("cn.com.vastbase.Driver");
        }
        Boolean parseStatus = true;
        if (PGProperty.PRIORITY_SERVERS.get(props) != null) {
            if (!GlobalClusterStatusTracker.isVaildPriorityServers(props)) {
                parseStatus = false;
            }
            GlobalClusterStatusTracker.refreshProperties(props);
        }
        if (MultiHostChooser.isUsingAutoLoadBalance(props)) {
            if (!MultiHostChooser.isVaildPriorityLoadBalance(props)) {
                parseStatus = false;
            }
            QueryCNListUtils.refreshProperties(props);
        }
        return parseStatus;
    }

    private Boolean initLoggerProperties(String driverLogLevel) {
        if (driverLogLevel == null) {
            return false;
        }
        if (!"OFF".equalsIgnoreCase(driverLogLevel) && !isLogFileCreated.compareAndSet(false, true)) {
            return false;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return false;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        } else if ("INFO".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.INFO);
        } else {
            PARENT_LOGGER.setLevel(Level.OFF);
        }
        return true;
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (!this.initLoggerProperties(driverLogLevel).booleanValue()) {
            return;
        }
        String driverLogFile = PGProperty.LOGGER_FILE.getDefaultValue();
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new WriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), formatter) : new StreamHandler(System.err, formatter));
        } else {
            handler.setFormatter(formatter);
        }
        handler.setLevel(PARENT_LOGGER.getLevel());
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        PgConnection pgConnection = new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
        GlobalConnectionTracker.possessConnectionReference(pgConnection.getQueryExecutor(), props);
        return pgConnection;
    }

    @Override
    public boolean acceptsURL(String url) throws PSQLException {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws PSQLException {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Deprecated
    public static String getVersion() {
        return "Vastbase JDBC Driver 2.8.4054";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static String parseIPValid(String address) {
        if (address == "" || address == null) {
            return address;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(address).matches()) {
            LOGGER.debug("JDBC URL invalid ip address: " + address);
        }
        return address;
    }

    public static Properties parseURL(String url, Properties defaults) throws PSQLException {
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        boolean isUrlLegal = false;
        String[] legalUrlTags = new String[]{"jdbc:vastbase:", "jdbc:dws:iam:"};
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        for (String urlTag : legalUrlTags) {
            if (!l_urlServer.startsWith(urlTag)) continue;
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            LOGGER.debug("JDBC URL must start with \"jdbc:vastbase:\" or \"jdbc:dws:iam:\" but was: " + Driver.filterAuthenticationCredentials(url));
            return null;
        }
        if ((l_urlServer = l_urlServer.substring("jdbc:vastbase:".length())).startsWith("//")) {
            int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                LOGGER.warn("JDBC URL must contain a / at the end of the host or port: " + Driver.filterAuthenticationCredentials(url));
                return null;
            }
            urlProps.setProperty("PGDBNAME", URLCoder.decode(l_urlServer.substring(slash + 1)));
            String[] addresses = l_urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 1 || port > 65535) {
                            LOGGER.warn("JDBC URL port: " + portStr + " not valid (1:65535) ");
                            return null;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        LOGGER.warn("JDBC URL invalid port number: " + portStr);
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(Driver.parseIPValid((String)address.subSequence(0, portIdx)));
                } else {
                    ports.append(DEFAULT_PORT);
                    hosts.append(Driver.parseIPValid(address));
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PGHOST", hosts.toString());
            urlProps.setProperty("PGPORT", ports.toString());
            urlProps.setProperty("PGHOSTURL", hosts.toString());
            urlProps.setProperty("PGPORTURL", ports.toString());
        } else {
            if (defaults == null || !defaults.containsKey("PGPORT")) {
                urlProps.setProperty("PGPORT", DEFAULT_PORT);
            }
            if (defaults == null || !defaults.containsKey("PGHOST")) {
                urlProps.setProperty("PGHOST", "localhost");
            }
            if (defaults == null || !defaults.containsKey("PGDBNAME")) {
                urlProps.setProperty("PGDBNAME", URLCoder.decode(l_urlServer));
            }
        }
        urlProps.putAll((Map<?, ?>)Driver.praseParam(l_urlArgs));
        if (urlProps.getProperty("enable_ce") != null && urlProps.getProperty("enable_ce").equals("1")) {
            urlProps.setProperty("CLIENTLOGIC", "1");
        }
        return urlProps;
    }

    private static String filterAuthenticationCredentials(String url) {
        String notSensitiveUrl = url;
        int paramStartIndex = notSensitiveUrl.indexOf("?");
        if (paramStartIndex != -1) {
            LinkedHashMap<String, String> paramsMap = Driver.praseParam(notSensitiveUrl.substring(paramStartIndex + 1));
            StringBuilder stringBuilder = new StringBuilder(notSensitiveUrl.substring(0, paramStartIndex) + "?");
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                boolean isKeyword = false;
                for (String sensitiveCharacter : SENSITIVE_CHARACTERS) {
                    if (!entry.getKey().equals(sensitiveCharacter)) continue;
                    isKeyword = true;
                    break;
                }
                if (isKeyword) continue;
                stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "&");
            }
            notSensitiveUrl = stringBuilder.toString();
            if (notSensitiveUrl.endsWith("?") || notSensitiveUrl.endsWith("&")) {
                notSensitiveUrl = notSensitiveUrl.substring(0, notSensitiveUrl.length() - 1);
            }
        }
        return notSensitiveUrl;
    }

    private static LinkedHashMap<String, String> praseParam(String urlArgs) {
        String[] args;
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                paramsMap.put(token, "");
                continue;
            }
            paramsMap.put(token.substring(0, l_pos), URLCoder.decode(token.substring(l_pos + 1)));
        }
        return paramsMap;
    }

    public static HostSpec[] GetHostSpecs(Properties props) {
        return Driver.hostSpecs(props);
    }

    public static HostSpec[] getURLHostSpecs(Properties props) {
        return Driver.urlHostSpecs(props);
    }

    public static String GetUser(Properties props) {
        return Driver.user(props);
    }

    public static String GetDatabase(Properties props) {
        return Driver.database(props);
    }

    private static HostSpec[] urlHostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORTURL").split(",");
        String[] hosts = props.getProperty("PGHOSTURL").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORT").split(",");
        String[] hosts = props.getProperty("PGHOST").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        if (Logger.isUsingJDKLogger()) {
            return PARENT_LOGGER;
        }
        return null;
    }

    public static SharedTimer getSharedTimer() {
        return sharedTimer;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        isLogFileCreated = new AtomicBoolean(false);
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static String getGSVersion() {
        return gsVersion;
    }

    static {
        PARENT_LOGGER = java.util.logging.Logger.getLogger("cn.com.vastbase");
        LOGGER = Logger.getLogger("cn.com.vastbase.Driver");
        sharedTimer = new SharedTimer();
        SENSITIVE_CHARACTERS = new String[]{"sslpassword", "iamPassword", "password"};
        tracerInitialized = new AtomicBoolean(false);
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

