/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastdata.vbapi.hash;

import cn.com.vastdata.vbapi.hash.BaseHash;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Timestamp;

public class VBHash {
    public static final long MAX_BUCKET = 0xFFFFFFFFL;
    private String charset = "utf8";

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public VBHash() {
    }

    public VBHash(String charset) {
        this.charset = charset;
    }

    public Long vb_hash(Byte key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Short key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Integer key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Long key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Float key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Double key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(String key) throws UnsupportedEncodingException {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Timestamp key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Date key) {
        return this.vb_hash(key, (Long)0xFFFFFFFFL);
    }

    public Long vb_hash(Byte key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashInt1(key);
        return value % maxBucket;
    }

    public Long vb_hash(Short key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashInt2(key);
        return value % maxBucket;
    }

    public Long vb_hash(Integer key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashInt4(key);
        return value % maxBucket;
    }

    public Long vb_hash(Long key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashInt8(key);
        return value % maxBucket;
    }

    public Long vb_hash(Float key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashFloat4(key.floatValue());
        return value % maxBucket;
    }

    public Long vb_hash(Double key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashFloat8(key);
        return value % maxBucket;
    }

    public Long vb_hash(String key, Long maxBucket) throws UnsupportedEncodingException {
        if (key == null || key.length() == 0 || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.vbHashVarlena(key, this.charset);
        return value % maxBucket;
    }

    public Long vb_hash(Timestamp key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashTimeStamp(key);
        return value % maxBucket;
    }

    public Long vb_hash(Date key, Long maxBucket) {
        if (key == null || maxBucket == null) {
            return null;
        }
        maxBucket = this.checkBucket(maxBucket);
        long value = BaseHash.hashDate(key);
        return value % maxBucket;
    }

    private long checkBucket(long maxBucket) {
        if (maxBucket < 0L || maxBucket > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("max_bucket must between 0 and 4294967295");
        }
        return ++maxBucket;
    }
}

