/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.hostchooser;

import com.kingbase8.KBProperty;
import com.kingbase8.hostchooser.CandidateHost;
import com.kingbase8.hostchooser.GlobalHostStatusTracker;
import com.kingbase8.hostchooser.HostChooser;
import com.kingbase8.hostchooser.HostRequirement;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KRuntimeException;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.TraceLogger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

class MultiHostChooser
implements HostChooser {
    private HostSpec[] hostSpecsT;
    private final HostRequirement targetServerTypeT;
    private int hostRecheckTimeT;
    private boolean loadBalanceT;
    private boolean fastFailoverT;

    MultiHostChooser(HostSpec[] _hostSpecs, HostRequirement targetServerType, Properties info) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.hostSpecsT = _hostSpecs;
        this.targetServerTypeT = targetServerType;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.hostRecheckTimeT = KBProperty.HOST_RECHECK_SECONDS.getInt(info) * 1000;
            this.loadBalanceT = KBProperty.LOAD_BALANCE_HOSTS.getBoolean(info);
            this.fastFailoverT = KBProperty.FAST_FAILOVER.getBoolean(info);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (KSQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KRuntimeException(e);
        }
    }

    @Override
    public Iterator<CandidateHost> iterator() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Iterator<CandidateHost> iterator = this.candidateIterator();
        if (!iterator.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            List<HostSpec> allHostsList = Arrays.asList(this.hostSpecsT);
            if (this.loadBalanceT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                allHostsList = new ArrayList<HostSpec>(allHostsList);
                Collections.shuffle(allHostsList);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            iterator = this.withReqStatus(this.targetServerTypeT, allHostsList).iterator();
        }
        return iterator;
    }

    private Iterator<CandidateHost> candidateIterator() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.targetServerTypeT != HostRequirement.preferSecondary) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getCandidateHosts(this.targetServerTypeT).iterator();
        }
        List<CandidateHost> secondariesList = this.getCandidateHosts(HostRequirement.secondary);
        List<CandidateHost> anyList = this.getCandidateHosts(HostRequirement.any);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (secondariesList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return anyList.iterator();
        }
        if (anyList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return secondariesList.iterator();
        }
        if (secondariesList.get(secondariesList.size() - 1).equals(anyList.get(0))) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            secondariesList = this.rtrim(1, secondariesList);
        }
        return this.append(secondariesList, anyList).iterator();
    }

    private List<CandidateHost> getCandidateHosts(HostRequirement _hostRequirement) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<HostSpec> candidatesList = GlobalHostStatusTracker.getCandidateHosts(this.hostSpecsT, _hostRequirement, this.hostRecheckTimeT, this.fastFailoverT);
        if (this.loadBalanceT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Collections.shuffle(candidatesList);
        }
        return this.withReqStatus(_hostRequirement, candidatesList);
    }

    private List<CandidateHost> withReqStatus(final HostRequirement requirement, final List<HostSpec> _hosts) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new AbstractList<CandidateHost>(){

            @Override
            public CandidateHost get(int _index) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new CandidateHost((HostSpec)_hosts.get(_index), requirement);
            }

            @Override
            public int size() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return _hosts.size();
            }
        };
    }

    private <T> List<T> append(final List<T> a, final List<T> b) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new AbstractList<T>(){

            @Override
            public T get(int _index) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return _index < a.size() ? a.get(_index) : b.get(_index - a.size());
            }

            @Override
            public int size() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return a.size() + b.size();
            }
        };
    }

    private <T> List<T> rtrim(final int size, final List<T> a) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new AbstractList<T>(){

            @Override
            public T get(int _index) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return a.get(_index);
            }

            @Override
            public int size() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Math.max(0, a.size() - size);
            }
        };
    }
}

