/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;

public class BlobNewOutputStream
extends OutputStream {
    private Blob largeObj;
    private byte[] _buf;
    private int bsize;
    private int bposition;
    private int blobposition;

    public BlobNewOutputStream(Blob largeObj, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.largeObj = largeObj;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.blobposition = position;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bsize = 1024;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._buf = new byte[this.bsize];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bposition = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void write(int b) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition >= this.bsize) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setBytes(this.blobposition, this._buf);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.blobposition += this._buf.length;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.bposition = 0;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            this._buf[this.bposition++] = (byte)b;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf, int off, int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.flush();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (off == 0 && leng == _buf.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setBytes(this.blobposition, _buf);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.blobposition += _buf.length;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setBytes(this.blobposition, _buf, off, leng);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.blobposition += leng;
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObj.setBytes(this.blobposition, this._buf, 0, this.bposition);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.blobposition += this.bposition;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.bposition = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObj != null) {
            this.flush();
            this.largeObj = null;
        }
    }

    private void checkIsClosed() throws IOException {
        if (this.largeObj == null) {
            throw new IOException("BlobNewOutputStream is closed");
        }
    }
}

