/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.Field;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.JdbcBlackHole;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class KbDatabaseMetaData
implements DatabaseMetaData {
    private static final boolean IS_TRUE = true;
    private static final boolean IS_FALSE = false;
    private static final int ZERO = 0;
    private int nameDataLengthT = 0;
    private int _indexMaxKeys = 0;
    protected final KbConnection _connection;
    private String _keywords;
    private static final HashMap<String, Map<String, String>> TABLE_TYPE_CLAUSES;

    public KbDatabaseMetaData(KbConnection _conn) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = _conn;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxIndexKeys() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._indexMaxKeys == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT setting FROM PG_CATALOG.PG_settings WHERE name='max_index_keys'";
            Statement stm = this._connection.createStatement();
            ResultSet resultSet = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultSet = stm.executeQuery(_sql);
                if (!resultSet.next()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    stm.close();
                    String s = "Unable to determine a _value for MaxIndexKeys";
                    String s1 = " due to missing system catalog data.";
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr(s + s1, new Object[0]), KSQLState.UNEXPECTED_ERROR);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._indexMaxKeys = resultSet.getInt(1);
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(resultSet);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(stm);
            }
        }
        return this._indexMaxKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxNameLength_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.nameDataLengthT == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT t.typlen FROM PG_CATALOG.PG_type t, PG_CATALOG.PG_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'";
            Statement stm = this._connection.createStatement();
            ResultSet resultSet = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                resultSet = stm.executeQuery(_sql);
                if (!resultSet.next()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String msg = "Unable to find name datatype in the system catalogs.";
                    throw new KSQLException(GT.tr(msg, new Object[0]), KSQLState.UNEXPECTED_ERROR);
                }
                this.nameDataLengthT = resultSet.getInt("typlen");
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(resultSet);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(stm);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        return this.nameDataLengthT - 1;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public String getUserName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String userName = this._connection.getUserName();
        return userName;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String url = this._connection.getURL();
        return url;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean readOnly = this._connection.isReadOnly();
        return readOnly;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "KingbaseES";
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public String getDriverName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "Kingbase8 JDBC Driver";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String dbVersionNumber = this._connection.getDBVersionNumber();
        return dbVersionNumber;
    }

    @Override
    public int getDriverMajorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int kingbaseMajorVersion = 0;
        return kingbaseMajorVersion;
    }

    @Override
    public String getDriverVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String kingbaseDriverVersion = "V008R006B0001";
        return kingbaseDriverVersion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getDriverMinorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int kingbaseMinorVersion = 0;
        return kingbaseMinorVersion;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return CompatibleDB.mysql(this._connection.getCompatibleLevel());
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "upper".equals(this._connection.getStoreCase());
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "lower".equals(this._connection.getStoreCase());
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "original".equals(this._connection.getStoreCase());
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return CompatibleDB.mysql(this._connection.getCompatibleLevel());
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = "\"";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        block4: {
            block5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._connection.checkIsClosed();
                String preArrayStr = "[";
                String sufArrayStr = "]";
                if (CompatibleDB.sqlserver(this._connection.getCompatibleLevel())) {
                    preArrayStr = "{";
                    sufArrayStr = "}";
                }
                if (this._keywords != null) break block4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!this._connection.haveMinimumServerVersion(ServerVersion.v9_0)) break block5;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                StringBuilder sb = new StringBuilder();
                sb.append("select ");
                sb.append("string_agg(word, ',') ");
                sb.append("from PG_CATALOG.PG_get_keywords() ");
                sb.append("where word <> ");
                sb.append("ALL ('{a,abs,absolute,action,");
                sb.append("ada,add,admin,after,");
                sb.append("all,allocate,alter,");
                sb.append("always,and,any,");
                sb.append("are,array,as,asc,");
                sb.append("asensitive,assertion,");
                sb.append("assignment,asymmetric,");
                sb.append("at,atomic,");
                sb.append("attribute,attributes,");
                sb.append("authorization,avg,before,");
                sb.append("begin,bernoulli,between,");
                sb.append("bigint,binary,");
                sb.append("blob,boolean,both,");
                sb.append("breadth,by,c,call,called,");
                sb.append("cardinality,cascade,");
                sb.append("cascaded,case,cast,");
                sb.append("catalog,catalog_name,");
                sb.append("ceil,ceiling,chain,char,");
                sb.append("char_length,character,");
                sb.append("character_length,");
                sb.append("character_set_catalog,");
                sb.append("character_set_name,");
                sb.append("character_set_schema,");
                sb.append("characteristics,");
                sb.append("characters,check,");
                sb.append("checked,class_origin,");
                sb.append("clob,close,coalesce,");
                sb.append("cobol,code_units,");
                sb.append("collate,");
                sb.append("collation,collation_catalog,");
                sb.append("collation_name,collation_schema,");
                sb.append("collect,column,");
                sb.append("column_name,command_function,");
                sb.append("command_function_code,");
                sb.append("commit,committed,condition,");
                sb.append("condition_number,connect,");
                sb.append("connection_name,");
                sb.append("constraint,constraint_catalog,");
                sb.append("constraint_name,");
                sb.append("constraint_schema,constraints,");
                sb.append("constructors,contains,continue,");
                sb.append("convert,corr,");
                sb.append("corresponding,count,");
                sb.append("covar_pop,covar_samp,");
                sb.append("create,cross,cube,");
                sb.append("cume_dist,current,");
                sb.append("current_collation,");
                sb.append("current_date,");
                sb.append("current_default_transform_group,");
                sb.append("current_path,");
                sb.append("current_role,");
                sb.append("current_time,current_timestamp,");
                sb.append("current_transform_group_for_type,");
                sb.append("current_user,");
                sb.append("cursor,cursor_name,");
                sb.append("cycle,data,date,");
                sb.append("datetime_interval_code,");
                sb.append("datetime_interval_precision,");
                sb.append("day,deallocate,dec,");
                sb.append("decimal,declare,default,");
                sb.append("defaults,deferrable,");
                sb.append("deferred,defined,definer,");
                sb.append("degree,delete,dense_rank,");
                sb.append("depth,deref,derived,desc,");
                sb.append("describe,descriptor,deterministic,");
                sb.append("diagnostics,disconnect,");
                sb.append("dispatch,distinct,domain,");
                sb.append("double,drop,dynamic,");
                sb.append("dynamic_function,");
                sb.append("dynamic_function_code,");
                sb.append("each,element,else,end,");
                sb.append("end-exec,equals,escape,every,except,");
                sb.append("exception,exclude,");
                sb.append("excluding,exec,execute,");
                sb.append("exists,exp,external,");
                sb.append("extract,false,fetch,filter,");
                sb.append("final,first,float,");
                sb.append("floor,following,for,");
                sb.append("foreign,fortran,found,");
                sb.append("free,from,full,function,");
                sb.append("fusion,g,general,get,");
                sb.append("global,go,goto,grant,");
                sb.append("granted,group,grouping,");
                sb.append("having,hierarchy,hold,");
                sb.append("hour,identity,immediate,");
                sb.append("implementation,in,including,");
                sb.append("increment,indicator,initially,");
                sb.append("inner,inout,input,insensitive,");
                sb.append("insert,instance,instantiable,");
                sb.append("int,integer,intersect,");
                sb.append("intersection,interval,into,");
                sb.append("invoker,is,isolation,join,");
                sb.append("k,key,key_member,key_type,");
                sb.append("language,");
                sb.append("large,last,lateral,");
                sb.append("leading,left,length,level,");
                sb.append("like,ln,local,localtime,");
                sb.append("localtimestamp,");
                sb.append("locator,lower,m,map,");
                sb.append("match,matched,max,maxvalue,");
                sb.append("member,merge,message_length,");
                sb.append("message_octet_length,");
                sb.append("message_text,method,min,");
                sb.append("minute,minvalue,mod,");
                sb.append("modifies,module,month,");
                sb.append("more,multiset,mumps,");
                sb.append("name,names,national,");
                sb.append("natural,nchar,nclob,nesting,");
                sb.append("new,next,no,none,");
                sb.append("normalize,normalized,");
                sb.append("not,\"null\",nullable,");
                sb.append("nullif,nulls,number,");
                sb.append("numeric,object,");
                sb.append("octet_length,octets,");
                sb.append("of,old,on,only,open,");
                sb.append("option,options,or,");
                sb.append("order,ordering,ordinality,");
                sb.append("others,out,outer,");
                sb.append("output,over,overlaps,");
                sb.append("overlay,overriding,pad,");
                sb.append("parameter,parameter_mode,");
                sb.append("parameter_name,");
                sb.append("parameter_ordinal_position,");
                sb.append("parameter_specific_catalog,");
                sb.append("parameter_specific_name,");
                sb.append("parameter_specific_schema,");
                sb.append("partial,partition,pascal,path,");
                sb.append("percent_rank,percentile_cont,");
                sb.append("percentile_disc,placing,pli,");
                sb.append("position,power,preceding,");
                sb.append("precision,prepare,preserve,");
                sb.append("primary,prior,privileges,");
                sb.append("procedure,public,range,");
                sb.append("rank,read,");
                sb.append("reads,real,recursive,");
                sb.append("ref,references,referencing,");
                sb.append("regr_avgx,regr_avgy,regr_count,");
                sb.append("regr_intercept,regr_r2,");
                sb.append("regr_slope,regr_sxx,regr_sxy,");
                sb.append("regr_syy,relative,release,");
                sb.append("repeatable,restart,result,");
                sb.append("return,returned_cardinality,");
                sb.append("returned_length,");
                sb.append("returned_octet_length,");
                sb.append("returned_sqlstate,returns,");
                sb.append("revoke,right,role,rollback,rollup,");
                sb.append("routine,routine_catalog,");
                sb.append("routine_name,routine_schema,");
                sb.append("row,row_count,row_number,rows,");
                sb.append("savepoint,scale,schema,");
                sb.append("schema_name,scope_catalog,");
                sb.append("scope_name,scope_schema,scroll,");
                sb.append("search,second,section,");
                sb.append("security,select,self,sensitive,");
                sb.append("sequence,serializable,server_name,");
                sb.append("session,session_user,");
                sb.append("set,sets,similar,simple,size,");
                sb.append("smallint,some,source,");
                sb.append("space,specific,");
                sb.append("specific_name,specifictype,");
                sb.append("sql,sqlexception,sqlstate,");
                sb.append("sqlwarning,sqrt,start,state,");
                sb.append("statement,static,stddev_pop,");
                sb.append("stddev_samp,structure,style,");
                sb.append("subclass_origin,submultiset,");
                sb.append("substring,sum,symmetric,");
                sb.append("system,system_user,table,");
                sb.append("table_name,tablesample,temporary,then,");
                sb.append("ties,time,timestamp,");
                sb.append("timezone_hour,timezone_minute,");
                sb.append("to,top_level_count,trailing,");
                sb.append("transaction,transaction_active,");
                sb.append("transactions_committed,");
                sb.append("transactions_rolled_back,");
                sb.append("transform,transforms,translate,");
                sb.append("translation,treat,trigger,");
                sb.append("trigger_catalog,trigger_name,");
                sb.append("trigger_schema,trim,true,");
                sb.append("type,uescape,unbounded,uncommitted,");
                sb.append("under,union,unique,unknown,");
                sb.append("unnamed,unnest,update,upper,");
                sb.append("usage,user,user_defined_type_catalog,");
                sb.append("user_defined_type_code,");
                sb.append("user_defined_type_name,");
                sb.append("user_defined_type_schema,using,");
                sb.append("value,values,var_pop,var_samp,");
                sb.append("varchar,varying,view,when,");
                sb.append("whenever,where,width_bucket,");
                sb.append("window,with,within,");
                sb.append("without,work,");
                sb.append("write,year,zone}'::text" + preArrayStr + sufArrayStr + ")");
                String _sql = sb.toString();
                Statement stm = null;
                ResultSet resultSet = null;
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    stm = this._connection.createStatement();
                    resultSet = stm.executeQuery(_sql);
                    if (!resultSet.next()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        String msg = "Unable to find _keywords in the system catalogs.";
                        throw new KSQLException(GT.tr(msg, new Object[0]), KSQLState.UNEXPECTED_ERROR);
                    }
                    this._keywords = resultSet.getString(1);
                }
                catch (Throwable throwable) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    JdbcBlackHole.close(resultSet);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    JdbcBlackHole.close(stm);
                    throw throwable;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(resultSet);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                JdbcBlackHole.close(stm);
                break block4;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sb = new StringBuilder();
            sb.append("abort,access,aggregate,");
            sb.append("also,analyse,analyze,");
            sb.append("backward,bit,cache,checkpoint,class,");
            sb.append("cluster,comment,concurrently,");
            sb.append("connection,conversion,copy,");
            sb.append("csv,database,delimiter,");
            sb.append("delimiters,disable,do,");
            sb.append("enable,encoding,encrypted,");
            sb.append("exclusive,explain,");
            sb.append("force,forward,freeze,");
            sb.append("greatest,handler,");
            sb.append("header,if,ilike,immutable,");
            sb.append("implicit,index,indexes,");
            sb.append("inherit,inherits,");
            sb.append("instead,isnull,least,");
            sb.append("limit,listen,load,location,");
            sb.append("lock,mode,move,nothing,notify,notnull,");
            sb.append("nowait,off,offset,oids,");
            sb.append("operator,owned,owner,");
            sb.append("password,prepared,procedural,");
            sb.append("quote,reassign,");
            sb.append("recheck,reindex,rename,");
            sb.append("replace,reset,restrict,");
            sb.append("returning,rule,setof,");
            sb.append("share,show,stable,");
            sb.append("statistics,stdin,");
            sb.append("stdout,storage,strict,");
            sb.append("sysid,tablespace,");
            sb.append("temp,template,truncate,trusted,");
            sb.append("unencrypted,unlisten,");
            sb.append("until,vacuum,valid,");
            sb.append("validator,verbose,volatile");
            this._keywords = sb.toString();
        }
        return this._keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("abs,acos,asin,");
        sb.append("atan,atan2,ceiling");
        sb.append(",cos,cot,degrees");
        sb.append(",exp,floor,log");
        sb.append(",log10,mod,pi");
        sb.append(",power,radians,");
        sb.append("round,sign,sin,");
        sb.append("sqrt,tan,truncate");
        return sb.toString();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("ascii,char,");
        sb.append("concat,lcase,left,");
        sb.append("length,ltrim,repeat");
        sb.append(",rtrim,space,");
        sb.append("substring,ucase");
        sb.append(",replace");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sb.toString();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 1600;
        return v;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = "database,ifnull,user";
        return s;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("curdate,curtime,");
        sb.append("dayname,dayofmonth,");
        sb.append("dayofweek,dayofyear,");
        sb.append("hour,minute,month,");
        sb.append("monthname,now,quarter");
        sb.append(",second,week,year");
        sb.append(",timestampadd");
        return sb.toString();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = "";
        return s;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public ResultSet getImportedKeys(String catalogT, String schemaT, String table) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet importedExportedKeys = this.getImportedExportedKeys(null, null, null, catalogT, schemaT, table);
        return importedExportedKeys;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String schema = "schema";
        return schema;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String function = "function";
        return function;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String database = "database";
        return database;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = ".";
        return s;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getJDBCMajorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 4;
        return v;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getMaxNameLength_();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxIndexKeys = this.getMaxIndexKeys();
        return maxIndexKeys;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 8192;
        return v;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 0x40000000;
        return v;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxNameLength_ = this.getMaxNameLength_();
        return maxNameLength_;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 2;
        return v;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int levelT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (levelT) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return true;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    protected String escapeQuotes(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sbu = new StringBuilder();
        if (!this._connection.getStandardConformingStrings()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append("E");
        }
        sbu.append("'");
        if (CompatibleDB.oracle(this._connection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("lower".equals(this._connection.getStoreCase())) {
                sbu.append(this._connection.escapeString(this.CapitalizeToLowercase(s)));
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(this._connection.escapeString(s));
            }
        } else if (CompatibleDB.mysql(this._connection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(this._connection.escapeString(s));
        } else if (CompatibleDB.notPg(this._connection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("lower".equals(this._connection.getStoreCase())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(this._connection.escapeString(this.CapitalizeToLowercase(s)));
            } else {
                sbu.append(this._connection.escapeString(s));
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(this._connection.escapeString(s));
        }
        sbu.append("'");
        return sbu.toString();
    }

    protected String CapitalizeToLowercase(String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean _flag = false;
        for (int i = 0; i < s.length(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char c = s.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _flag = true;
            break;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s1 = _flag ? s : s.toLowerCase();
        return s1;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String tString = " p.proname || '_' || p.oid AS SPECIFIC_NAME ";
        if (CompatibleDB.mysql(this._connection.getCompatibleLevel())) {
            tString = " concat(p.proname,'_',p.oid) AS SPECIFIC_NAME ";
        }
        String _sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE, " + tString + " FROM PG_CATALOG.PG_namespace n, PG_CATALOG.PG_proc p  LEFT JOIN PG_CATALOG.PG_description d ON (p.oid=d.objoid)  LEFT JOIN PG_CATALOG.PG_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN PG_CATALOG.PG_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + "and pg_function_is_visible(p.oid)";
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND p.proname LIKE " + this.escapeQuotes(procedureNamePattern);
        }
        if (this._connection.getHideUnprivilegedObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND has_function_privilege(p.oid,'EXECUTE')";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " ORDER BY PROCEDURE_SCHEM, ";
        _sql = _sql + " PROCEDURE_NAME, p.oid::text ";
        Statement tmpStatement = this.createMetaDataStatement();
        ResultSet resultSet = tmpStatement.executeQuery(_sql);
        return resultSet;
    }

    @Override
    public ResultSet getExportedKeys(String catalogT, String schemaT, String table) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet importedExportedKeys = this.getImportedExportedKeys(catalogT, schemaT, table, null, null, null);
        return importedExportedKeys;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tablNamePattern, String[] types) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String useSchemasStr = "SCHEMAS";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String selectStr = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname ~ '^pg_' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'p' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   WHEN 'S' THEN 'TEMPORARY SEQUENCE'   WHEN 'v' THEN 'TEMPORARY VIEW'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'p' THEN 'TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  WHEN 'c' THEN 'TYPE'  WHEN 'f' THEN 'FOREIGN TABLE'  WHEN 'm' THEN 'MATERIALIZED VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS,  '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION  FROM PG_CATALOG.PG_namespace n, PG_CATALOG.PG_class c  LEFT JOIN PG_CATALOG.PG_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN PG_CATALOG.PG_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN PG_CATALOG.PG_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + " AND (c.oid not in (select oid  from recyclebin))";
        }
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (this._connection.getHideUnprivilegedObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + " AND has_table_privilege(c.oid,  'SELECT, INSERT, UPDATE, DELETE, RULE, REFERENCES, TRIGGER')";
        }
        String orderbyStr = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (tablNamePattern != null && !tablNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + " AND c.relname LIKE " + this.escapeQuotes(tablNamePattern);
        }
        if (types != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + " AND (false ";
            StringBuilder orClause = new StringBuilder();
            for (String type : types) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Map<String, String> clauses = TABLE_TYPE_CLAUSES.get(type);
                if (clauses == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String clause = clauses.get(useSchemasStr);
                orClause.append(" OR ( ").append(clause).append(" ) ");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            selectStr = selectStr + orClause.toString() + ") ";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = selectStr + orderbyStr;
        Statement metaDataStatement = this.createMetaDataStatement();
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typNamePattern, String attributeNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String functionNameStr = " getAttributes( String,String,String,String)";
        SQLFeatureNotSupportedException throwables = Driver.notImplemented(this.getClass(), functionNameStr);
        throw throwables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String catalogName, String schemaPattern, String procedureNamePattern, String columnNamePatternT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _columns = 20;
        Field[] fieldT = new Field[_columns];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String PROCEDURE_CAT = "PROCEDURE_CAT";
        String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String PROCEDURE_NAME = "PROCEDURE_NAME";
        String COLUMN_NAME = "COLUMN_NAME";
        String COLUMN_TYPE = "COLUMN_TYPE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DATA_TYPE = "DATA_TYPE";
        String TYPE_NAME = "TYPE_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String PRECISION = "PRECISION";
        String LENGTH = "LENGTH";
        String SCALE = "SCALE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String RADIX = "RADIX";
        String NULLABLE = "NULLABLE";
        String REMARKS = "REMARKS";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String COLUMN_DEF = "COLUMN_DEF";
        String SQL_DATA_TYPE = "SQL_DATA_TYPE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
        String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String ORDINAL_POSITION = "ORDINAL_POSITION";
        String IS_NULLABLE = "IS_NULLABLE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SPECIFIC_NAME = "SPECIFIC_NAME";
        fieldT[0] = new Field("PROCEDURE_CAT", 1043);
        fieldT[1] = new Field("PROCEDURE_SCHEM", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("PROCEDURE_NAME", 1043);
        fieldT[3] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("COLUMN_TYPE", 21);
        fieldT[5] = new Field("DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[6] = new Field("TYPE_NAME", 1043);
        fieldT[7] = new Field("PRECISION", 23);
        fieldT[8] = new Field("LENGTH", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[9] = new Field("SCALE", 21);
        fieldT[10] = new Field("RADIX", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[11] = new Field("NULLABLE", 21);
        fieldT[12] = new Field("REMARKS", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[13] = new Field("COLUMN_DEF", 1043);
        fieldT[14] = new Field("SQL_DATA_TYPE", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[15] = new Field("SQL_DATETIME_SUB", 23);
        fieldT[16] = new Field("CHAR_OCTET_LENGTH", 23);
        fieldT[17] = new Field("ORDINAL_POSITION", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[18] = new Field("IS_NULLABLE", 1043);
        fieldT[19] = new Field("SPECIFIC_NAME", 1043);
        String _sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid, ";
        _sql = _sql + " p.proargnames, p.proargmodes, p.proallargtypes, p.oid ";
        _sql = _sql + " FROM PG_CATALOG.PG_proc p, PG_CATALOG.PG_namespace n, PG_CATALOG.PG_type t ";
        _sql = _sql + " WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND p.proname LIKE " + this.escapeQuotes(procedureNamePattern);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " ORDER BY n.nspname, p.proname, p.oid::text ";
        byte[] isnullableUnknown = new byte[]{};
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            resultSet = stm.executeQuery(_sql);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (resultSet.next()) {
                byte[] procedureName = resultSet.getBytes("proname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] schema = resultSet.getBytes("nspname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] specificName = this._connection._encodeString(resultSet.getString("proname") + "_" + resultSet.getString("oid"));
                String strArgTypes = resultSet.getString("proargtypes");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String returnTypeTypeT = resultSet.getString("typtype");
                int returnType = (int)resultSet.getLong("prorettype");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int returnTypeRelid = (int)resultSet.getLong("typrelid");
                ArrayList<Long> argTypesList = new ArrayList<Long>();
                StringTokenizer stringTokenizer = new StringTokenizer(strArgTypes);
                while (stringTokenizer.hasMoreTokens()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argTypesList.add(Long.valueOf(stringTokenizer.nextToken()));
                }
                Array argNamesArray = resultSet.getArray("proargnames");
                String[] argNamesT = null;
                if (argNamesArray != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argNamesT = (String[])argNamesArray.getArray();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String[] argModesT = null;
                Array argModesArray = resultSet.getArray("proargmodes");
                if (argModesArray != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argModesT = (String[])argModesArray.getArray();
                }
                int numArgsT = argTypesList.size();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Long[] allArgTypes = null;
                Array allArgTypesArray = resultSet.getArray("proallargtypes");
                if (allArgTypesArray != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    allArgTypes = (Long[])allArgTypesArray.getArray();
                    numArgsT = allArgTypes.length;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (returnTypeTypeT.equals("b") || returnTypeTypeT.equals("d") || returnTypeTypeT.equals("e") || returnTypeTypeT.equals("p") && argModesArray == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[][] _tuple = new byte[_columns][];
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[0] = null;
                    _tuple[1] = schema;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[2] = procedureName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[3] = this._connection._encodeString("returnValue");
                    _tuple[4] = this._connection._encodeString(Integer.toString(5));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(returnType));
                    _tuple[7] = null;
                    _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(returnType)));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[9] = null;
                    _tuple[10] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[8] = null;
                    _tuple[11] = this._connection._encodeString(Integer.toString(2));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[17] = this._connection._encodeString(Integer.toString(0));
                    _tuple[12] = null;
                    _tuple[18] = isnullableUnknown;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[19] = specificName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    v.add(_tuple);
                }
                for (int i = 0; i < numArgsT; ++i) {
                    int argOid;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[][] _tuple = new byte[_columns][];
                    _tuple[0] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[1] = schema;
                    _tuple[2] = procedureName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (argNamesT != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[3] = this._connection._encodeString(argNamesT[i]);
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        byte[] bytes = this._connection._encodeString("$" + (i + 1));
                        _tuple[3] = bytes;
                    }
                    int _columnMode = 1;
                    if (argModesT != null && argModesT[i].equals("o")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnMode = 4;
                    } else if (argModesT != null && argModesT[i].equals("b")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnMode = 2;
                    } else if (argModesT != null && argModesT[i].equals("t")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnMode = 5;
                    }
                    _tuple[4] = this._connection._encodeString(Integer.toString(_columnMode));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (allArgTypes != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        argOid = allArgTypes[i].intValue();
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        argOid = ((Long)argTypesList.get(i)).intValue();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(argOid));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(argOid)));
                    _tuple[7] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[9] = null;
                    _tuple[8] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[10] = null;
                    _tuple[11] = this._connection._encodeString(Integer.toString(2));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[17] = this._connection._encodeString(Integer.toString(i + 1));
                    _tuple[12] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[18] = isnullableUnknown;
                    _tuple[19] = specificName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    v.add(_tuple);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                if (!returnTypeTypeT.equals("c") && (!returnTypeTypeT.equals("p") || argModesArray == null)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _column_sql = "SELECT a.attname,a.atttypid FROM PG_CATALOG.PG_attribute a  WHERE a.attrelid = " + returnTypeRelid + " AND (NOT a.attisdropped OR (a.attisdropped AND strpos(array_to_string(a.attoptions,','),'column_id=null'))) AND a.attnum > 0 ORDER BY a.attnum ";
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Statement _columnstm = null;
                ResultSet _columnrs = null;
                try {
                    _columnstm = this._connection.createStatement();
                    _columnrs = _columnstm.executeQuery(_column_sql);
                    while (_columnrs.next()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        byte[][] _tuple = new byte[_columns][];
                        int _columnTypeOid = (int)_columnrs.getLong("atttypid");
                        _tuple[1] = schema;
                        _tuple[0] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[3] = _columnrs.getBytes("attname");
                        _tuple[2] = procedureName;
                        _tuple[4] = this._connection._encodeString(Integer.toString(3));
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[7] = null;
                        _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(_columnTypeOid));
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[9] = null;
                        _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(_columnTypeOid)));
                        _tuple[8] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[10] = null;
                        _tuple[11] = this._connection._encodeString(Integer.toString(2));
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[17] = this._connection._encodeString(Integer.toString(0));
                        _tuple[12] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[18] = isnullableUnknown;
                        _tuple[19] = specificName;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        v.add(_tuple);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                }
                finally {
                    if (_columnrs != null) {
                        _columnrs.close();
                    }
                    if (_columnstm == null) continue;
                    _columnstm.close();
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String tStr = "[1]";
        if (CompatibleDB.sqlserver(this._connection.getCompatibleLevel())) {
            tStr = "{1}";
        }
        String _sql = "SELECT nspname AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM PG_CATALOG.PG_namespace  WHERE nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_'  OR nspname = (pg_catalog.current_schemas(true))" + tStr + ") AND (nspname !~ '^pg_toast_temp_'  OR nspname = replace((pg_catalog.current_schemas(true))" + tStr + ", 'pg_temp_', 'pg_toast_temp_')) ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (this._connection.getHideUnprivilegedObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND has_schema_privilege(nspname, 'USAGE, CREATE')";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " ORDER BY TABLE_SCHEM";
        Statement metaDataStatement = this.createMetaDataStatement();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String catalog = null;
        String schemaPattern = null;
        ResultSet v = this.getSchemas(catalog, schemaPattern);
        return v;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[1];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        fieldT[0] = new Field("TABLE_CAT", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[][] _tuple = new byte[1][];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[0] = this._connection._encodeString(this._connection.getCatalog());
        v.add(_tuple);
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object[] typesT = TABLE_TYPE_CLAUSES.keySet().toArray(new String[0]);
        Arrays.sort(typesT);
        Field[] fieldT = new Field[1];
        ArrayList<byte[][]> vList = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("TABLE_TYPE", 1043);
        for (Object type : typesT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[][] _tuple = new byte[][]{this._connection._encodeString((String)type)};
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            vList.add(_tuple);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, vList);
        return driverResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tablNamePattern, String _columnNamePattern) throws SQLException {
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numberOfFields = 24;
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        Field[] fieldT = new Field[numberOfFields];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_CAT = "TABLE_CAT";
        String TABLE_SCHEM = "TABLE_SCHEM";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_NAME = "TABLE_NAME";
        String COLUMN_NAME = "COLUMN_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DATA_TYPE = "DATA_TYPE";
        String TYPE_NAME = "TYPE_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String COLUMN_SIZE = "COLUMN_SIZE";
        String BUFFER_LENGTH = "BUFFER_LENGTH";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DECIMAL_DIGITS = "DECIMAL_DIGITS";
        String NUM_PREC_RADIX = "NUM_PREC_RADIX";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String NULLABLE = "NULLABLE";
        String REMARKS = "REMARKS";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String COLUMN_DEF = "COLUMN_DEF";
        String SQL_DATA_TYPE = "SQL_DATA_TYPE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
        String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String ORDINAL_POSITION = "ORDINAL_POSITION";
        String IS_NULLABLE = "IS_NULLABLE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SCOPE_CATALOG = "SCOPE_CATALOG";
        String SCOPE_SCHEMA = "SCOPE_SCHEMA";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SCOPE_TABLE = "SCOPE_TABLE";
        String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
        String IS_GENERATEDCOLUMN = "IS_GENERATEDCOLUMN";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("TABLE_CAT", 1043);
        fieldT[1] = new Field("TABLE_SCHEM", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("TABLE_NAME", 1043);
        fieldT[3] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[5] = new Field("TYPE_NAME", 1043);
        fieldT[6] = new Field("COLUMN_SIZE", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[7] = new Field("BUFFER_LENGTH", 1043);
        fieldT[8] = new Field("DECIMAL_DIGITS", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[9] = new Field("NUM_PREC_RADIX", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[10] = new Field("NULLABLE", 23);
        fieldT[11] = new Field("REMARKS", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[12] = new Field("COLUMN_DEF", 1043);
        fieldT[13] = new Field("SQL_DATA_TYPE", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[14] = new Field("SQL_DATETIME_SUB", 23);
        fieldT[15] = new Field("CHAR_OCTET_LENGTH", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[16] = new Field("ORDINAL_POSITION", 23);
        fieldT[17] = new Field("IS_NULLABLE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[18] = new Field("SCOPE_CATALOG", 1043);
        fieldT[19] = new Field("SCOPE_SCHEMA", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[20] = new Field("SCOPE_TABLE", 1043);
        fieldT[21] = new Field("SOURCE_DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[22] = new Field("IS_AUTOINCREMENT", 1043);
        fieldT[23] = new Field("IS_GENERATEDCOLUMN", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = "SELECT * FROM (";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = "";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + "SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,t.typtypmod,";
        if (this._connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + "row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, ";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + "a.attnum,";
        }
        if (this._connection.haveMinimumServerVersion(ServerVersion.v10)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("on".equalsIgnoreCase(this._connection.getOra_input_emptystr_isnull()) && CompatibleDB.oracle(this._connection.getCompatibleLevel())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + "nullif(length(a.attidentity), 0) as attidentity,";
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + "nullif(a.attidentity, '') as attidentity,";
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + "null as attidentity,";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + "PG_CATALOG.PG_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype  FROM PG_CATALOG.PG_namespace n  JOIN PG_CATALOG.PG_class c ON (c.relnamespace = n.oid)  JOIN PG_CATALOG.PG_attribute a ON (a.attrelid=c.oid)  JOIN PG_CATALOG.PG_type t ON (a.atttypid = t.oid)  LEFT JOIN PG_CATALOG.PG_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN PG_CATALOG.PG_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN PG_CATALOG.PG_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN PG_CATALOG.PG_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE c.relkind in ('r','p','v','f','m') and a.attnum > 0 AND (NOT a.attisdropped OR (a.attisdropped AND strpos(array_to_string(a.attoptions,','),'column_id=null'))) ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (c.oid not in (select oid  from recyclebin))";
        }
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tablNamePattern != null && !tablNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND c.relname LIKE " + this.escapeQuotes(tablNamePattern);
        }
        if (this._connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + ") c WHERE true ";
        }
        if (_columnNamePattern != null && !_columnNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND attname LIKE " + this.escapeQuotes(_columnNamePattern);
        }
        _sql = _sql + " ORDER BY nspname,c.relname,attnum ";
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            resultSet = stm.executeQuery(_sql);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (resultSet.next()) {
                int _columnSize;
                int decimalDigits;
                int _sqlType;
                if ("upper".equals(this._connection.getStoreCase()) && "ROWID".equals(resultSet.getString("attname")) || "lower".equals(this._connection.getStoreCase()) && "rowid".equals(resultSet.getString("attname")) || "original".equals(this._connection.getStoreCase()) && "rowid".equals(resultSet.getString("attname").toLowerCase())) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] _tuple = new byte[numberOfFields][];
                int typeOid = (int)resultSet.getLong("atttypid");
                int typeMod = resultSet.getInt("atttypmod");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[0] = null;
                _tuple[1] = resultSet.getBytes("nspname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[2] = resultSet.getBytes("relname");
                _tuple[3] = resultSet.getBytes("attname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String typtype = resultSet.getString("typtype");
                if ("c".equals(typtype)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlType = 2002;
                } else if ("d".equals(typtype)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlType = 2001;
                    Integer _sqlTypeDomain = null;
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _sqlTypeDomain = this._connection.getTypeInfo().getSQLType(typeOid);
                    }
                    catch (Exception e) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        System.out.println(e.getMessage());
                    }
                    if (_sqlTypeDomain != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _sqlType = _sqlTypeDomain;
                    }
                } else if ("e".equals(typtype)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlType = 12;
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlType = this._connection.getTypeInfo().getSQLType(typeOid);
                }
                _tuple[4] = this._connection._encodeString(Integer.toString(_sqlType));
                String kbType = null;
                if (typeOid == 1186 || typeOid == 7000 || typeOid == 7002) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    kbType = this._connection.getTypeInfo().getKBTypeWithMod(typeOid, typeMod);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    kbType = this._connection.getTypeInfo().getKBType(typeOid);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[7] = null;
                _tuple[5] = this._connection._encodeString(kbType);
                String defvalue = resultSet.getString("adsrc");
                if (defvalue != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (kbType.equals("int4")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (defvalue.contains("nextval(")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[5] = this._connection._encodeString("serial");
                        }
                    } else if (kbType.equals("int8")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (defvalue.contains("nextval(")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[5] = this._connection._encodeString("bigserial");
                        }
                    } else if (kbType.equals("int2")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (defvalue.contains("nextval(")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[5] = this._connection._encodeString("smallserial");
                        }
                    }
                }
                String identity = resultSet.getString("attidentity");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int baseTypeOid = (int)resultSet.getLong("typbasetype");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_sqlType == 2001) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int typtypmod = resultSet.getInt("typtypmod");
                    decimalDigits = this._connection.getTypeInfo().getScale(baseTypeOid, typeMod);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (typtypmod == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnSize = this._connection.getTypeInfo().getColumnSize(baseTypeOid, typeMod);
                    } else if (baseTypeOid == 1700) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        decimalDigits = this._connection.getTypeInfo().getScale(baseTypeOid, typtypmod);
                        _columnSize = this._connection.getTypeInfo().getColumnSize(baseTypeOid, typtypmod);
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnSize = typtypmod;
                    }
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    decimalDigits = this._connection.getTypeInfo().getScale(typeOid, typeMod);
                    _columnSize = this._connection.getTypeInfo().getColumnSize(typeOid, typeMod);
                    if (_columnSize == 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _columnSize = this._connection.getTypeInfo().getDisplaySize(typeOid, typeMod);
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[6] = this._connection._encodeString(Integer.toString(_columnSize));
                _tuple[8] = this._connection._encodeString(Integer.toString(decimalDigits));
                _tuple[9] = this._connection._encodeString("10");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (kbType.equals("bit") || kbType.equals("varbit")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[9] = this._connection._encodeString("2");
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[10] = this._connection._encodeString(Integer.toString(resultSet.getBoolean("attnotnull") ? 0 : 1));
                _tuple[11] = resultSet.getBytes("description");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[13] = null;
                _tuple[12] = resultSet.getBytes("adsrc");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[14] = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[16] = this._connection._encodeString(String.valueOf(resultSet.getInt("attnum")));
                _tuple[15] = _tuple[6];
                if (CompatibleDB.notPg(this._connection.getCompatibleLevel())) {
                    _tuple[15] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getDisplaySize(typeOid, typeMod)));
                }
                _tuple[18] = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[17] = this._connection._encodeString(resultSet.getBoolean("attnotnull") ? "NO" : "YES");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[19] = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[21] = baseTypeOid == 0 ? null : this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(baseTypeOid)));
                _tuple[20] = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String autoinc = "NO";
                if (defvalue != null && defvalue.contains("nextval(") || identity != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    autoinc = "YES";
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[22] = this._connection._encodeString(autoinc);
                _tuple[23] = this._connection._encodeString("");
                v.add(_tuple);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalogT, String schemaT, String table, String _columnNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_CAT = "TABLE_CAT";
        String TABLE_SCHEM = "TABLE_SCHEM";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_NAME = "TABLE_NAME";
        String COLUMN_NAME = "COLUMN_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String GRANTOR = "GRANTOR";
        String GRANTEE = "GRANTEE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String PRIVILEGE = "PRIVILEGE";
        String IS_GRANTABLE = "IS_GRANTABLE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("TABLE_CAT", 1043);
        fieldT[1] = new Field("TABLE_SCHEM", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("TABLE_NAME", 1043);
        fieldT[3] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("GRANTOR", 1043);
        fieldT[5] = new Field("GRANTEE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[6] = new Field("PRIVILEGE", 1043);
        fieldT[7] = new Field("IS_GRANTABLE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT n.nspname,c.relname,r.rolname,c.relacl, " + (this._connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "a.attacl, " : "") + " a.attname  FROM PG_CATALOG.PG_namespace n, PG_CATALOG.PG_class c,  PG_CATALOG.PG_roles r, PG_CATALOG.PG_attribute a  WHERE c.relnamespace = n.oid  AND c.relowner = r.oid  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND (NOT a.attisdropped OR (a.attisdropped AND strpos(array_to_string(a.attoptions,','),'column_id=null'))) ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (c.oid not in (select oid  from recyclebin))";
        }
        if (schemaT != null && !schemaT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname = " + this.escapeQuotes(schemaT);
        }
        if (table != null && !table.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND c.relname = " + this.escapeQuotes(table);
        }
        if (_columnNamePattern != null && !_columnNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND a.attname LIKE " + this.escapeQuotes(_columnNamePattern);
        }
        _sql = _sql + " ORDER BY attname ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            resultSet = stm.executeQuery(_sql);
            while (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String owner = resultSet.getString("rolname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] _column = resultSet.getBytes("attname");
                byte[] tablName = resultSet.getBytes("relname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String relAcl = resultSet.getString("relacl");
                byte[] schemaName = resultSet.getBytes("nspname");
                Map<String, Map<String, List<String[]>>> permissionsMap = this.parseACL(relAcl, owner);
                if (this._connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
                    String _acl = resultSet.getString("attacl");
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Map<String, Map<String, List<String[]>>> relPermissionsMap = this.parseACL(_acl, owner);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    permissionsMap.putAll(relPermissionsMap);
                }
                Object[] permNamesT = permissionsMap.keySet().toArray(new String[0]);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Arrays.sort(permNamesT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (Object permNameT : permNamesT) {
                    Map<String, List<String[]>> granteesMap = permissionsMap.get(permNameT);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] privilege = this._connection._encodeString((String)permNameT);
                    for (Map.Entry<String, List<String[]>> userToGrantableMap : granteesMap.entrySet()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        List<String[]> grantor = userToGrantableMap.getValue();
                        String grantee = userToGrantableMap.getKey();
                        for (String[] grantTuples : grantor) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            String grantable = owner.equals(grantee) ? "YES" : grantTuples[1];
                            byte[][] _tuple = new byte[8][];
                            _tuple[1] = schemaName;
                            _tuple[0] = null;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[4] = this._connection._encodeString(grantTuples[0]);
                            _tuple[2] = tablName;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[3] = _column;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[6] = privilege;
                            _tuple[7] = this._connection._encodeString(grantable);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[5] = this._connection._encodeString(grantee);
                            v.add(_tuple);
                        }
                    }
                }
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultSet != null) {
                resultSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stm != null) {
                stm.close();
            }
        }
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tablNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[7];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_CAT = "TABLE_CAT";
        String TABLE_SCHEM = "TABLE_SCHEM";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String TABLE_NAME = "TABLE_NAME";
        String GRANTOR = "GRANTOR";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String GRANTEE = "GRANTEE";
        String PRIVILEGE = "PRIVILEGE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String IS_GRANTABLE = "IS_GRANTABLE";
        fieldT[0] = new Field("TABLE_CAT", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[1] = new Field("TABLE_SCHEM", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("TABLE_NAME", 1043);
        fieldT[3] = new Field("GRANTOR", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("GRANTEE", 1043);
        fieldT[5] = new Field("PRIVILEGE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[6] = new Field("IS_GRANTABLE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT n.nspname,c.relname,r.rolname,c.relacl  FROM PG_CATALOG.PG_namespace n, PG_CATALOG.PG_class c, PG_CATALOG.PG_roles r  WHERE c.relnamespace = n.oid  AND c.relowner = r.oid  AND c.relkind IN ('r','p') ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (c.oid not in (select oid  from recyclebin))";
        }
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tablNamePattern != null && !tablNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND c.relname LIKE " + this.escapeQuotes(tablNamePattern);
        }
        _sql = _sql + " ORDER BY nspname, relname ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            resultSet = stm.executeQuery(_sql);
            while (resultSet.next()) {
                String _acl = resultSet.getString("relacl");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] table = resultSet.getBytes("relname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String owner = resultSet.getString("rolname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] schema = resultSet.getBytes("nspname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Map<String, Map<String, List<String[]>>> permissionMap = this.parseACL(_acl, owner);
                Object[] permNamesT = permissionMap.keySet().toArray(new String[0]);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Arrays.sort(permNamesT);
                for (Object permNameStr : permNamesT) {
                    Map<String, List<String[]>> granteesMap = permissionMap.get(permNameStr);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] privilege = this._connection._encodeString((String)permNameStr);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    for (Map.Entry<String, List<String[]>> userToGrantable : granteesMap.entrySet()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        List<String[]> grantTuples = userToGrantable.getValue();
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        String granteeUser = userToGrantable.getKey();
                        for (String[] grantTuple : grantTuples) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            String grantor = grantTuple[0] == null ? owner : grantTuple[0];
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            String grantable = owner.equals(granteeUser) ? "YES" : grantTuple[1];
                            byte[][] _tuple = new byte[7][];
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[6] = this._connection._encodeString(grantable);
                            _tuple[0] = null;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[5] = privilege;
                            _tuple[1] = schema;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[3] = this._connection._encodeString(grantor);
                            _tuple[2] = table;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuple[4] = this._connection._encodeString(granteeUser);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            v.add(_tuple);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        }
                    }
                }
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultSet != null) {
                resultSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stm != null) {
                stm.close();
            }
        }
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SCOPE = "SCOPE";
        String COLUMN_NAME = "COLUMN_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DATA_TYPE = "DATA_TYPE";
        String TYPE_NAME = "TYPE_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String COLUMN_SIZE = "COLUMN_SIZE";
        String BUFFER_LENGTH = "BUFFER_LENGTH";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DECIMAL_DIGITS = "DECIMAL_DIGITS";
        String PSEUDO_COLUMN = "PSEUDO_COLUMN";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("SCOPE", 21);
        fieldT[1] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[3] = new Field("TYPE_NAME", 1043);
        fieldT[4] = new Field("COLUMN_SIZE", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[5] = new Field("BUFFER_LENGTH", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[6] = new Field("DECIMAL_DIGITS", 21);
        fieldT[7] = new Field("PSEUDO_COLUMN", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT a.attname, a.atttypid, atttypmod FROM PG_CATALOG.PG_class ct   JOIN PG_CATALOG.PG_attribute a ON (ct.oid = a.attrelid)   JOIN PG_CATALOG.PG_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM PG_CATALOG.PG_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid) WHERE true ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (ct.oid not in (select oid  from recyclebin))";
        }
        if (schema != null && !schema.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        _sql = _sql + " AND ct.relname = " + this.escapeQuotes(table) + " AND i.indisprimary  ORDER BY a.attnum ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = stm.executeQuery(_sql);
            while (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] _tuple = new byte[8][];
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int typeOid = (int)resultSet.getLong("atttypid");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int typeMod = resultSet.getInt("atttypmod");
                int decimalDigits = this._connection.getTypeInfo().getScale(typeOid, typeMod);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _columnSize = this._connection.getTypeInfo().getColumnSize(typeOid, typeMod);
                if (_columnSize == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _columnSize = this._connection.getTypeInfo().getDisplaySize(typeOid, typeMod);
                }
                _tuple[0] = this._connection._encodeString(Integer.toString(scope));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[1] = resultSet.getBytes("attname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[2] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(typeOid)));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[3] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(typeOid));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[4] = this._connection._encodeString(Integer.toString(_columnSize));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[6] = this._connection._encodeString(Integer.toString(decimalDigits));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[5] = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[7] = this._connection._encodeString(Integer.toString(1));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                v.add(_tuple);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultSet != null) {
                resultSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stm != null) {
                stm.close();
            }
        }
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    private static List<String> parseACLArray(String _aclString) {
        int i;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<String> aclsList = new ArrayList<String>();
        if (_aclString == null || _aclString.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return aclsList;
        }
        boolean inQuotesT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int beginIndexT = 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int prevCharT = 32;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = beginIndexT; i < _aclString.length(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char cT = _aclString.charAt(i);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cT == '\"' && prevCharT != 92) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                inQuotesT = !inQuotesT;
            } else if (cT == ',' && !inQuotesT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                aclsList.add(_aclString.substring(beginIndexT, i));
                beginIndexT = i + 1;
            }
            prevCharT = cT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        aclsList.add(_aclString.substring(beginIndexT, _aclString.length() - 1));
        for (i = 0; i < aclsList.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _acl = (String)aclsList.get(i);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!_acl.startsWith("\"") || !_acl.endsWith("\"")) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _acl = _acl.substring(1, _acl.length() - 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            aclsList.set(i, _acl);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return aclsList;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String SCOPE = "SCOPE";
        String COLUMN_NAME = "COLUMN_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DATA_TYPE = "DATA_TYPE";
        String TYPE_NAME = "TYPE_NAME";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String COLUMN_SIZE = "COLUMN_SIZE";
        String BUFFER_LENGTH = "BUFFER_LENGTH";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DECIMAL_DIGITS = "DECIMAL_DIGITS";
        String PSEUDO_COLUMN = "PSEUDO_COLUMN";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("SCOPE", 21);
        fieldT[1] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[3] = new Field("TYPE_NAME", 1043);
        fieldT[4] = new Field("COLUMN_SIZE", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[5] = new Field("BUFFER_LENGTH", 23);
        fieldT[6] = new Field("DECIMAL_DIGITS", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[7] = new Field("PSEUDO_COLUMN", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[][] _tuple = new byte[8][];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[0] = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[1] = this._connection._encodeString("ctid");
        _tuple[2] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType("tid")));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[3] = this._connection._encodeString("tid");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[4] = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _tuple[6] = null;
        _tuple[7] = this._connection._encodeString(Integer.toString(2));
        _tuple[5] = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        v.add(_tuple);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (i.keys).n AS KEY_SEQ, ci.relname AS PK_NAME FROM PG_CATALOG.PG_class ct   JOIN PG_CATALOG.PG_attribute a ON (ct.oid = a.attrelid)   JOIN PG_CATALOG.PG_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              information_schema._pg_expandarray(i.indkey) AS keys         FROM PG_CATALOG.PG_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid)   JOIN PG_CATALOG.PG_class ci ON (ci.oid = i.indexrelid) WHERE true ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (ct.oid not in (select oid  from recyclebin))";
        }
        if (schema != null && !schema.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND ct.relname = " + this.escapeQuotes(table);
        }
        _sql = _sql + " AND i.indisprimary  ORDER BY table_name, pk_name, key_seq";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement statement = this.createMetaDataStatement();
        ResultSet resultSet = statement.executeQuery(_sql);
        return resultSet;
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String preArrayStr = "[";
        String sufArrayStr = "]";
        if (CompatibleDB.sqlserver(this._connection.getCompatibleLevel())) {
            preArrayStr = "{";
            sufArrayStr = "}";
        }
        String _sql = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, position.n AS KEY_SEQ, CASE _con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE _con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'p' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, _con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN _con.condeferrable AND _con.condeferred THEN 5 WHEN _con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  PG_CATALOG.PG_namespace pkn, PG_CATALOG.PG_class pkc, PG_CATALOG.PG_attribute pka,  PG_CATALOG.PG_namespace fkn, PG_CATALOG.PG_class fkc, PG_CATALOG.PG_attribute fka,  PG_CATALOG.PG_constraint _con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") position(n),  PG_CATALOG.PG_class pkic";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + ", PG_CATALOG.PG_depend dep ";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = _con.confkey" + preArrayStr + "position.n" + sufArrayStr + " AND _con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = _con.conkey" + preArrayStr + "position.n" + sufArrayStr + " AND _con.conrelid = fkc.oid  AND _con.contype = 'f' AND pkic.relkind = 'i' ";
        if (!this._connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND _con.oid = dep.objid AND pkic.oid = dep.refobjid AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid ";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND pkic.oid = _con.conindid ";
        }
        if (primarySchema != null && !primarySchema.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND pkn.nspname = " + this.escapeQuotes(primarySchema);
        }
        if (foreignSchema != null && !foreignSchema.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND fkn.nspname = " + this.escapeQuotes(foreignSchema);
        }
        if (primaryTable != null && !primaryTable.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND pkc.relname = " + this.escapeQuotes(primaryTable);
        }
        if (foreignTable != null && !foreignTable.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND fkc.relname = " + this.escapeQuotes(foreignTable);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (primaryTable != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " ORDER BY fkn.nspname,fkc.relname,_con.conname,position.n";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " ORDER BY pkn.nspname,pkc.relname, _con.conname,position.n";
        }
        Statement metaDataStatement = this.createMetaDataStatement();
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    private static void internalAddACLPriv(String aclStr, Map<String, Map<String, List<String[]>>> privMap) {
        String privsT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int equalIndexT = aclStr.lastIndexOf("=");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int slashIndexT = aclStr.lastIndexOf("/");
        if (equalIndexT == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String userT = aclStr.substring(0, equalIndexT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String grantorT = null;
        if (userT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            userT = "PUBLIC";
        }
        if (slashIndexT != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            privsT = aclStr.substring(equalIndexT + 1, slashIndexT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            grantorT = aclStr.substring(slashIndexT + 1, aclStr.length());
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            privsT = aclStr.substring(equalIndexT + 1, aclStr.length());
        }
        for (int i = 0; i < privsT.length(); ++i) {
            String _sqlpriv;
            String grantable;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char c = privsT.charAt(i);
            if (c == '*') continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i < privsT.length() - 1 && privsT.charAt(i + 1) == '*') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                grantable = "YES";
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                grantable = "NO";
            }
            switch (c) {
                case 'a': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "INSERT";
                    break;
                }
                case 'p': 
                case 'r': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "DELETE";
                    break;
                }
                case 'D': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "TRUNCATE";
                    break;
                }
                case 'R': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    String UNKNOWN;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sqlpriv = UNKNOWN = "UNKNOWN";
                }
            }
            String[] grantArray = new String[]{grantorT, grantable};
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Map<String, List<String[]>> usersWithPermissionMap = privMap.get(_sqlpriv);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (usersWithPermissionMap == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ArrayList<String[]> _permissionByGrantor = new ArrayList<String[]>();
                usersWithPermissionMap = new HashMap<String, List<String[]>>();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _permissionByGrantor.add(grantArray);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                usersWithPermissionMap.put(userT, _permissionByGrantor);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                privMap.put(_sqlpriv, usersWithPermissionMap);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            List<String[]> _permissionByGrantorList = usersWithPermissionMap.get(userT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_permissionByGrantorList == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _permissionByGrantorList = new ArrayList<String[]>();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _permissionByGrantorList.add(grantArray);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                usersWithPermissionMap.put(userT, _permissionByGrantorList);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _permissionByGrantorList.add(grantArray);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[18];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("TYPE_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[1] = new Field("DATA_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("PRECISION", 23);
        fieldT[3] = new Field("LITERAL_PREFIX", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("LITERAL_SUFFIX", 1043);
        fieldT[5] = new Field("CREATE_PARAMS", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[6] = new Field("NULLABLE", 21);
        fieldT[7] = new Field("CASE_SENSITIVE", 16);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[8] = new Field("SEARCHABLE", 21);
        fieldT[9] = new Field("UNSIGNED_ATTRIBUTE", 16);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[10] = new Field("FIXED_PREC_SCALE", 16);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[11] = new Field("AUTO_INCREMENT", 16);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[12] = new Field("LOCAL_TYPE_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[13] = new Field("MINIMUM_SCALE", 21);
        fieldT[14] = new Field("MAXIMUM_SCALE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[15] = new Field("SQL_DATA_TYPE", 23);
        fieldT[16] = new Field("SQL_DATETIME_SUB", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[17] = new Field("NUM_PREC_RADIX", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT t.typname,t.oid,t.typtype,t.typinput='array_in'::regproc FROM PG_CATALOG.PG_type t JOIN PG_CATALOG.PG_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname  != 'pg_toast' AND  (t.typrelid = 0";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND t.typelem not in (SELECT ty.oid FROM PG_CATALOG.PG_type ty where ty.typrelid in (select oid  from recyclebin))";
        }
        _sql = _sql + " OR (SELECT c.relkind = 'c' FROM PG_CATALOG.PG_class c WHERE c.oid = t.typrelid";
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND  (c.oid not in (select oid  from recyclebin))";
        }
        _sql = _sql + "))";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideUnprivilegedObjects() && this._connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND has_type_privilege(t.oid, 'USAGE')";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = stm.executeQuery(_sql);
            byte[] bliteral = this._connection._encodeString("'");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] b10 = this._connection._encodeString("10");
            byte[] bSearchable = this._connection._encodeString(Integer.toString(3));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] bf = this._connection._encodeString("f");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] bt = this._connection._encodeString("t");
            byte[] bNullable = this._connection._encodeString(Integer.toString(1));
            byte[] bZero = this._connection._encodeString("0");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (resultSet.next()) {
                byte[][] _tuple1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[][] _tuple = new byte[19][];
                String typname = resultSet.getString(1);
                int typeOid = (int)resultSet.getLong(2);
                String typType = resultSet.getString(3);
                boolean isArray = resultSet.getBoolean(4);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[0] = this._connection._encodeString(typname);
                int _sqlType = this._connection.getFastTypeInfo() ? this._connection.getTypeInfo().getFastSQLType(typname, typType, isArray) : this._connection.getTypeInfo().getSQLType(typname);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[1] = this._connection._encodeString(Integer.toString(_sqlType));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[18] = BigInteger.valueOf(_sqlType).toByteArray();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[2] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getMaximumPrecision(typeOid)));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this._connection.getTypeInfo().requiresQuotingSqlType(_sqlType)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[3] = bliteral;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[4] = bliteral;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[6] = bNullable;
                _tuple[7] = this._connection.getTypeInfo().isCaseSensitive(typeOid) ? bt : bf;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[8] = bSearchable;
                _tuple[9] = this._connection.getTypeInfo().isSigned(typeOid) ? bf : bt;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[10] = bf;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[11] = bf;
                _tuple[13] = bZero;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[14] = typeOid == 1700 ? this._connection._encodeString("1000") : bZero;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple[17] = b10;
                v.add(_tuple);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typname.equals("int4")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple1 = (byte[][])_tuple.clone();
                    _tuple1[0] = this._connection._encodeString("serial");
                    _tuple1[11] = bt;
                    v.add(_tuple1);
                    continue;
                }
                if (typname.equals("int8")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple1 = (byte[][])_tuple.clone();
                    _tuple1[0] = this._connection._encodeString("bigserial");
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple1[11] = bt;
                    v.add(_tuple1);
                    continue;
                }
                if (!typname.equals("int2")) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple1 = (byte[][])_tuple.clone();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple1[0] = this._connection._encodeString("smallserial");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _tuple1[11] = bt;
                v.add(_tuple1);
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultSet != null) {
                resultSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stm != null) {
                stm.close();
            }
        }
        Collections.sort(v, new Comparator<byte[][]>(){

            @Override
            public int compare(byte[][] o1, byte[][] o2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int i1 = ByteConverter._bytesToInt(o1[18]);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int i2 = ByteConverter._bytesToInt(o2[18]);
                int i = i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return i;
            }
        });
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public ResultSet getIndexInfo(String catalogT, String schemaT, String tablNameT, boolean uniqueT, boolean approximateT) throws SQLException {
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String preArrayStr = "[";
        String sufArrayStr = "]";
        if (CompatibleDB.sqlserver(this._connection.getCompatibleLevel())) {
            preArrayStr = "{";
            sufArrayStr = "}";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE,   NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,   CASE i.indisclustered     WHEN true THEN 1    ELSE CASE am.amname       WHEN 'hash' THEN 2      ELSE 3    END   END AS TYPE,   (i.keys).n AS ORDINAL_POSITION,   trim(both '\"' from PG_CATALOG.PG_get_indexdef(ci.oid, (i.keys).n, false)) AS COLUMN_NAME, " + (this._connection.haveMinimumServerVersion(ServerVersion.v9_6) ? "  CASE am.amname     WHEN 'btree' THEN CASE i.indoption" + preArrayStr + "(i.keys).n - 1" + sufArrayStr + " & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, " : "  CASE am.amcanorder     WHEN true THEN CASE i.indoption" + preArrayStr + "(i.keys).n - 1" + sufArrayStr + " & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, ") + "  ci.reltuples AS CARDINALITY,   ci.relpages AS PAGES,   PG_CATALOG.PG_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION FROM PG_CATALOG.PG_class ct   JOIN PG_CATALOG.PG_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indoption,           i.indisunique, i.indisclustered, i.indpred,           i.indexprs,           information_schema._pg_expandarray(i.indkey) AS keys         FROM PG_CATALOG.PG_index i) i     ON (ct.oid = i.indrelid)   JOIN PG_CATALOG.PG_class ci ON (ci.oid = i.indexrelid)   JOIN PG_CATALOG.PG_am am ON (ci.relam = am.oid) WHERE true ";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (schemaT != null && !schemaT.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + " AND n.nspname = " + this.escapeQuotes(schemaT);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String selectT = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
            String fromT = " FROM PG_CATALOG.PG_namespace n, PG_CATALOG.PG_class ct, PG_CATALOG.PG_class ci,  PG_CATALOG.PG_attribute a, PG_CATALOG.PG_am am ";
            String whereT = " AND n.oid = ct.relnamespace ";
            fromT = fromT + ", PG_CATALOG.PG_index i ";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (schemaT != null && !schemaT.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                whereT = whereT + " AND n.nspname = " + this.escapeQuotes(schemaT);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = selectT + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,  CASE i.indisclustered  WHEN true THEN " + 1 + " ELSE CASE am.amname  WHEN 'hash' THEN " + 2 + " ELSE " + 3 + " END  END AS TYPE,  a.attnum AS ORDINAL_POSITION,  CASE WHEN i.indexprs IS NULL THEN a.attname  ELSE PG_CATALOG.PG_get_indexdef(ci.oid,a.attnum,false) END AS COLUMN_NAME,  NULL AS ASC_OR_DESC,  ci.reltuples AS CARDINALITY,  ci.relpages AS PAGES,  PG_CATALOG.PG_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION " + fromT + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + whereT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.getHideRecycledObjects()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND (ct.oid not in (select oid  from recyclebin))";
        }
        _sql = _sql + " AND ct.relname = " + this.escapeQuotes(tablNameT);
        if (uniqueT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND i.indisunique ";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        Statement metaDataStatement = this.createMetaDataStatement();
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    @Override
    public boolean supportsResultSetType(int typeT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = typeT != 1005;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return b;
    }

    @Override
    public boolean supportsResultSetConcurrency(int typeT, int concurrencyT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (typeT == 1005) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (concurrencyT == 1008) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    public Map<String, Map<String, List<String[]>>> parseACL(String aclArrayStr, String ownerName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (aclArrayStr == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String permsStr = this._connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "arwdDxt" : "arwdxt";
            aclArrayStr = "{" + ownerName + "=" + permsStr + "/" + ownerName + "}";
        }
        HashMap<String, Map<String, List<String[]>>> privMap = new HashMap<String, Map<String, List<String[]>>>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<String> _acls = KbDatabaseMetaData.parseACLArray(aclArrayStr);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (String _acl : _acls) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbDatabaseMetaData.internalAddACLPriv(_acl, privMap);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return privMap;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typNamePattern, int[] types) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "select null as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, pg_catalog.obj_description(t.oid, 'pg_type')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _sqlwhen = new StringBuilder();
        Iterator<String> iterator = this._connection.getTypeInfo().getKBTypeNamesWithSQLTypes();
        while (iterator.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String kbType = iterator.next();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _sqlType = this._connection.getTypeInfo().getSQLType(kbType);
            String str = " when typname = ";
            _sqlwhen.append(str).append(this.escapeQuotes(kbType)).append(" then ").append(_sqlType);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + _sqlwhen.toString();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " else 1111 end from pg_type where oid=t.typbasetype) else null end as base_type from PG_CATALOG.PG_type t, PG_CATALOG.PG_namespace n where t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder toAddMore = new StringBuilder();
        if (types != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            toAddMore.append(" and (false ");
            block5: for (Object typeInt : (String)types) {
                switch (typeInt) {
                    case 2002: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        toAddMore.append(" or t.typtype = 'c'");
                        continue block5;
                    }
                    case 2001: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        toAddMore.append(" or t.typtype = 'd'");
                    }
                }
            }
            toAddMore.append(" ) ");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            toAddMore.append(" and t.typtype IN ('c','d') ");
        }
        if (typNamePattern != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int firstQualifier = typNamePattern.indexOf(46);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int secondQualifier = typNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (firstQualifier != secondQualifier) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    schemaPattern = typNamePattern.substring(firstQualifier + 1, secondQualifier);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    schemaPattern = typNamePattern.substring(0, firstQualifier);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typNamePattern = typNamePattern.substring(secondQualifier + 1);
            }
            toAddMore.append(" and t.typname like ").append(this.escapeQuotes(typNamePattern));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (schemaPattern != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            toAddMore.append(" and n.nspname like ").append(this.escapeQuotes(schemaPattern));
        }
        _sql = _sql + toAddMore.toString();
        if (this._connection.getHideUnprivilegedObjects() && this._connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND has_type_privilege(t.oid, 'USAGE')";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql = _sql + " order by data_type, type_schem, type_name";
        Statement metaDataStatement = this.createMetaDataStatement();
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._connection;
    }

    protected Statement createMetaDataStatement() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement statement = this._connection.createStatement(1004, 1007);
        return statement;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.oracle(this._connection.getCompatibleLevel())) {
            if (this._connection.isDatabaseSupportRowid()) {
                return RowIdLifetime.ROWID_VALID_FOREVER;
            }
            return RowIdLifetime.ROWID_VALID_TRANSACTION;
        }
        if (CompatibleDB.mysql(this._connection.getCompatibleLevel())) {
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
        SQLFeatureNotSupportedException throwables = Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
        throw throwables;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field[] fieldT = new Field[4];
        fieldT[0] = new Field("NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[1] = new Field("MAX_LEN", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("DEFAULT_VALUE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[3] = new Field("DESCRIPTION", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[][] _tuple = new byte[4][];
            _tuple[0] = this._connection._encodeString("ApplicationName");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _tuple[1] = this._connection._encodeString(Integer.toString(this.getMaxNameLength_()));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _tuple[2] = this._connection._encodeString("");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String strT = "The name of the application currently utilizing the _connection.";
            _tuple[3] = this._connection._encodeString(strT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            v.add(_tuple);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean assignableFrom = clz.isAssignableFrom(this.getClass());
        return assignableFrom;
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            T cast = clz.cast(this);
            return cast;
        }
        SQLException throwables = new SQLException("Cannot unwrap to " + clz.getName());
        throw throwables;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean pgFuncResultExists = this._connection.haveMinimumServerVersion(ServerVersion.v8_4);
        String funcTypeSqlT = "0 ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (pgFuncResultExists) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funcTypeSqlT = " CASE    WHEN (format_type(p.prorettype, null) = 'unknown') THEN 0   WHEN      (pg_catalog.substring(pg_get_function_result(p.oid) ,0,6) = 'TABLE') OR      (pg_catalog.substring(pg_get_function_result(p.oid) ,0,6) = 'SETOF') THEN 2   ELSE 1 END ";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String tString = " p.proname || '_' || p.oid AS SPECIFIC_NAME ";
        if (CompatibleDB.mysql(this._connection.getCompatibleLevel())) {
            tString = " concat(p.proname,'_',p.oid) AS SPECIFIC_NAME ";
        }
        String _sql = "SELECT current_database() AS FUNCTION_CAT, n.nspname AS FUNCTION_SCHEM, p.proname AS FUNCTION_NAME,  d.description AS REMARKS, " + funcTypeSqlT + " AS FUNCTION_TYPE, " + tString + "FROM PG_CATALOG.PG_proc p INNER JOIN PG_CATALOG.PG_namespace n ON p.pronamespace=n.oid LEFT JOIN PG_CATALOG.PG_description d ON p.oid=d.objoid WHERE true  ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + "and pg_function_is_visible(p.oid)";
        }
        if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND p.proname LIKE " + this.escapeQuotes(functionNamePattern);
        }
        if (this._connection.getHideUnprivilegedObjects()) {
            _sql = _sql + " AND has_function_privilege(p.oid,'EXECUTE')";
        }
        _sql = _sql + " ORDER BY FUNCTION_SCHEM, FUNCTION_NAME, p.oid::text ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement metaDataStatement = this.createMetaDataStatement();
        ResultSet resultSet = metaDataStatement.executeQuery(_sql);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String _columnNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _columns = 17;
        Field[] fieldT = new Field[_columns];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[0] = new Field("FUNCTION_CAT", 1043);
        fieldT[1] = new Field("FUNCTION_SCHEM", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[2] = new Field("FUNCTION_NAME", 1043);
        fieldT[3] = new Field("COLUMN_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[4] = new Field("COLUMN_TYPE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[5] = new Field("DATA_TYPE", 21);
        fieldT[6] = new Field("TYPE_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[7] = new Field("PRECISION", 21);
        fieldT[8] = new Field("LENGTH", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[9] = new Field("SCALE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[10] = new Field("RADIX", 21);
        fieldT[11] = new Field("NULLABLE", 21);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[12] = new Field("REMARKS", 1043);
        fieldT[13] = new Field("CHAR_OCTET_LENGTH", 23);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[14] = new Field("ORDINAL_POSITION", 23);
        fieldT[15] = new Field("IS_NULLABLE", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        fieldT[16] = new Field("SPECIFIC_NAME", 1043);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid,  p.proargnames, p.proargmodes, p.proallargtypes, p.oid  FROM PG_CATALOG.PG_proc p, PG_CATALOG.PG_namespace n, PG_CATALOG.PG_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + " AND p.proname LIKE " + this.escapeQuotes(functionNamePattern);
        }
        _sql = _sql + " ORDER BY n.nspname, p.proname, p.oid::text ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] isnullableUnknown = new byte[]{};
        Statement stm = null;
        ResultSet resultSet = null;
        try {
            stm = this._connection.createStatement();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = stm.executeQuery(_sql);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (resultSet.next()) {
                byte[] functionName = resultSet.getBytes("proname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] schema = resultSet.getBytes("nspname");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] specificName = this._connection._encodeString(resultSet.getString("proname") + "_" + resultSet.getString("oid"));
                String strArgTypes = resultSet.getString("proargtypes");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String returnTypeTypeT = resultSet.getString("typtype");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int returnTypeRelid = (int)resultSet.getLong("typrelid");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int returnType = (int)resultSet.getLong("prorettype");
                ArrayList<Long> argTypesList = new ArrayList<Long>();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                StringTokenizer stringTokenizer = new StringTokenizer(strArgTypes);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (stringTokenizer.hasMoreTokens()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argTypesList.add(Long.valueOf(stringTokenizer.nextToken()));
                }
                String[] argNamesT = null;
                Array argNamesArrayT = resultSet.getArray("proargnames");
                if (argNamesArrayT != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argNamesT = (String[])argNamesArrayT.getArray();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                String[] argModesT = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Array argModesArrayT = resultSet.getArray("proargmodes");
                if (argModesArrayT != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    argModesT = (String[])argModesArrayT.getArray();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int numArgs = argTypesList.size();
                Long[] allArgTypesT = null;
                Array allArgTypesArray = resultSet.getArray("proallargtypes");
                if (allArgTypesArray != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    allArgTypesT = (Long[])allArgTypesArray.getArray();
                    numArgs = allArgTypesT.length;
                }
                if (returnTypeTypeT.equals("b") || returnTypeTypeT.equals("d") || returnTypeTypeT.equals("e") || returnTypeTypeT.equals("p") && argModesArrayT == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[][] _tuple = new byte[_columns][];
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[0] = null;
                    _tuple[1] = schema;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[2] = functionName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[3] = this._connection._encodeString("returnValue");
                    _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(returnType)));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[4] = this._connection._encodeString(Integer.toString(4));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[7] = null;
                    _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(returnType));
                    _tuple[9] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[8] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[10] = null;
                    _tuple[11] = this._connection._encodeString(Integer.toString(2));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[14] = this._connection._encodeString(Integer.toString(0));
                    _tuple[12] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[15] = isnullableUnknown;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[16] = specificName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    v.add(_tuple);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int i = 0; i < numArgs; ++i) {
                    int argOid;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[][] _tuple = new byte[_columns][];
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[0] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[1] = schema;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[2] = functionName;
                    if (argNamesT != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[3] = this._connection._encodeString(argNamesT[i]);
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        byte[] bytes = this._connection._encodeString("$" + (i + 1));
                        _tuple[3] = bytes;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int _columnMode = 1;
                    if (argModesT != null && argModesT[i] != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (argModesT[i].equals("o")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _columnMode = 3;
                        } else if (argModesT[i].equals("b")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _columnMode = 2;
                        } else if (argModesT[i].equals("t")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _columnMode = 4;
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[4] = this._connection._encodeString(Integer.toString(_columnMode));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (allArgTypesT != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        argOid = allArgTypesT[i].intValue();
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        argOid = ((Long)argTypesList.get(i)).intValue();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(argOid));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[7] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(argOid)));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[9] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[8] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[10] = null;
                    _tuple[11] = this._connection._encodeString(Integer.toString(2));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[14] = this._connection._encodeString(Integer.toString(i + 1));
                    _tuple[12] = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[15] = isnullableUnknown;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _tuple[16] = specificName;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    v.add(_tuple);
                }
                if (!returnTypeTypeT.equals("c") && (!returnTypeTypeT.equals("p") || argModesArrayT == null)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _column_sql = "SELECT a.attname,a.atttypid FROM PG_CATALOG.PG_attribute a  WHERE a.attrelid = " + returnTypeRelid + " AND (NOT a.attisdropped OR (a.attisdropped AND strpos(array_to_string(a.attoptions,','),'column_id=null'))) AND a.attnum > 0 ORDER BY a.attnum ";
                Statement _columnstm = null;
                ResultSet _columnrs = null;
                try {
                    _columnstm = this._connection.createStatement();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _columnrs = _columnstm.executeQuery(_column_sql);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    while (_columnrs.next()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        byte[][] _tuple = new byte[_columns][];
                        int _columnTypeOid = (int)_columnrs.getLong("atttypid");
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[0] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[2] = functionName;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[1] = schema;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[3] = _columnrs.getBytes("attname");
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[4] = this._connection._encodeString(Integer.toString(5));
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[6] = this._connection._encodeString(this._connection.getTypeInfo().getKBType(_columnTypeOid));
                        _tuple[7] = null;
                        _tuple[5] = this._connection._encodeString(Integer.toString(this._connection.getTypeInfo().getSQLType(_columnTypeOid)));
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[9] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[8] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[10] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        String strT = Integer.toString(2);
                        _tuple[11] = this._connection._encodeString(strT);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[14] = this._connection._encodeString(Integer.toString(0));
                        _tuple[12] = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[15] = isnullableUnknown;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuple[16] = specificName;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        v.add(_tuple);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                }
                finally {
                    if (_columnrs != null) {
                        _columnrs.close();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_columnstm != null) {
                        _columnstm.close();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultSet != null) {
                resultSet.close();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stm != null) {
                stm.close();
            }
        }
        BaseStatement tmpStatement = (BaseStatement)this.createMetaDataStatement();
        ResultSet driverResultSet = tmpStatement.createDriverResultSet(fieldT, v);
        return driverResultSet;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalogT, String primarySchemaT, String primaryTableT, String foreignCatalogT, String foreignSchemaT, String foreignTableT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet importedExportedKeys = this.getImportedExportedKeys(primaryCatalogT, primarySchemaT, primaryTableT, foreignCatalogT, foreignSchemaT, foreignTableT);
        return importedExportedKeys;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String catalogT, String schemaPatternT, String tablNamePatternT, String _columnNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String functionNameStr = "getPseudoColumns(String, String, String, String)";
        SQLFeatureNotSupportedException throwables = Driver.notImplemented(this.getClass(), functionNameStr);
        throw throwables;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int serverMajorVersion = this._connection.getServerMajorVersion();
        return serverMajorVersion;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String functionNameStr = "getSuperTypes(String,String,String)";
        SQLFeatureNotSupportedException throwables = Driver.notImplemented(this.getClass(), functionNameStr);
        throw throwables;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 1;
        return v;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tablNamePattern) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String functionNameStr = " getSuperTables( String,String,String,String)";
        SQLFeatureNotSupportedException throwables = Driver.notImplemented(this.getClass(), functionNameStr);
        throw throwables;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public int getJDBCMinorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int kinbaseJdbcMinorVersion = 2;
        return kinbaseJdbcMinorVersion;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 2;
        return v;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int serverMinorVersion = this._connection.getServerMinorVersion();
        return serverMinorVersion;
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES = new HashMap();
        HashMap<String, String> htable = new HashMap<String, String>();
        TABLE_TYPE_CLAUSES.put("TABLE", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        htable.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname !~ '^pg_'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("VIEW", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        htable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("INDEX", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        htable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("SEQUENCE", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'S'");
        htable.put("NOSCHEMAS", "c.relkind = 'S'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("TYPE", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'");
        htable.put("NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("SYSTEM TABLE", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        htable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("SYSTEM TOAST TABLE", htable);
        htable.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        htable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("SYSTEM TOAST INDEX", htable);
        htable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        htable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("SYSTEM VIEW", htable);
        htable.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        htable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("SYSTEM INDEX", htable);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        htable.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        htable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("TEMPORARY TABLE", htable);
        htable.put("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ");
        htable.put("NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ");
        htable = new HashMap();
        TABLE_TYPE_CLAUSES.put("TEMPORARY INDEX", htable);
        htable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ");
        htable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("TEMPORARY VIEW", htable);
        htable.put("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ");
        htable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("TEMPORARY SEQUENCE", htable);
        htable.put("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ");
        htable.put("NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("FOREIGN TABLE", htable);
        htable.put("SCHEMAS", "c.relkind = 'f'");
        htable.put("NOSCHEMAS", "c.relkind = 'f'");
        htable = new HashMap();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TABLE_TYPE_CLAUSES.put("MATERIALIZED VIEW", htable);
        htable.put("SCHEMAS", "c.relkind = 'm'");
        htable.put("NOSCHEMAS", "c.relkind = 'm'");
    }
}

