/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.core.v3.TypeTransferModeRegistry;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public class BatchedQuery
extends SimpleQuery {
    private String sqlStr;
    private final int valuesBraceOpenPos;
    private final int valuesBraceClosePos;
    private final int batchSizeT;
    private BatchedQuery[] blocksT;

    public BatchedQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, int valuesBraceOpenPosition, int valuesBraceClosePosition, boolean sanitiserDisabled) {
        super(query, transferModeRegistry, sanitiserDisabled);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceClosePos = valuesBraceClosePosition;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceOpenPos = valuesBraceOpenPosition;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.batchSizeT = 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private BatchedQuery(BatchedQuery batchedQuery, int batchSize) {
        super(batchedQuery);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceOpenPos = batchedQuery.valuesBraceOpenPos;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceClosePos = batchedQuery.valuesBraceClosePos;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.batchSizeT = batchSize;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public BatchedQuery deriveForMultiBatch(int valueBlockT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getBatchSize() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (valueBlockT == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int indexT = Integer.numberOfTrailingZeros(valueBlockT) - 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (valueBlockT > 128 || valueBlockT != 1 << indexT + 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("Expected _value block should be a power of 2 smaller or equal to 128. Actual block is " + valueBlockT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.blocksT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.blocksT = new BatchedQuery[7];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BatchedQuery batchedQueryT = this.blocksT[indexT];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (batchedQueryT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            batchedQueryT = new BatchedQuery(this, valueBlockT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.blocksT[indexT] = batchedQueryT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return batchedQueryT;
    }

    @Override
    public int getBatchSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.batchSizeT;
    }

    @Override
    public String getNativeSql() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.sqlStr != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.sqlStr;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sqlStr = this.buildNativeSql(null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.sqlStr;
    }

    private String buildNativeSql(ParameterList parameterList) {
        int positionT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sqlStr = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String nativeSqlStr = super.getNativeSql();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int batchSizeT = this.getBatchSize();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (batchSizeT < 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlStr = nativeSqlStr;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return sqlStr;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nativeSqlStr == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlStr = "";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return sqlStr;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int valuesBlockCharCountT = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] bindPositionsT = this.getNativeQuery()._bindPositions;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] chrunkStartT = new int[1 + bindPositionsT.length];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] chrunkEndT = new int[1 + bindPositionsT.length];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        chrunkStartT[0] = this.valuesBraceOpenPos;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bindPositionsT.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            valuesBlockCharCountT = this.valuesBraceClosePos - this.valuesBraceOpenPos + 1;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            chrunkEndT[0] = this.valuesBraceClosePos + 1;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            chrunkEndT[0] = bindPositionsT[0];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            valuesBlockCharCountT += chrunkEndT[0] - chrunkStartT[0];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < bindPositionsT.length; ++i) {
                int startIndexT;
                int endIndexT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int n = endIndexT = i < bindPositionsT.length - 1 ? bindPositionsT[i + 1] : this.valuesBraceClosePos + 1;
                for (startIndexT = bindPositionsT[i] + 2; startIndexT < endIndexT; ++startIndexT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!Character.isDigit(nativeSqlStr.charAt(startIndexT))) break;
                }
                chrunkStartT[i + 1] = startIndexT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                chrunkEndT[i + 1] = endIndexT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                valuesBlockCharCountT += chrunkEndT[i + 1] - chrunkStartT[i + 1];
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int lengthT = nativeSqlStr.length();
        lengthT += NativeQuery.calculateBindLength(bindPositionsT.length * batchSizeT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        lengthT -= NativeQuery.calculateBindLength(bindPositionsT.length);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder stringBuilder = new StringBuilder(lengthT += (valuesBlockCharCountT + 1) * (batchSizeT - 1));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bindPositionsT.length > 0 && parameterList == null) {
            stringBuilder.append(nativeSqlStr, 0, this.valuesBraceClosePos + 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            positionT = bindPositionsT.length + 1;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            positionT = 1;
            ++batchSizeT;
            stringBuilder.append(nativeSqlStr, 0, this.valuesBraceOpenPos);
        }
        for (int i = 2; i <= batchSizeT; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 2 || positionT != 1) {
                stringBuilder.append(',');
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.append(nativeSqlStr, chrunkStartT[0], chrunkEndT[0]);
            for (int j = 1; j < chrunkStartT.length; ++j) {
                if (parameterList == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    NativeQuery.appendBindName(stringBuilder, positionT++);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    stringBuilder.append(parameterList.toString(positionT++, true));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(nativeSqlStr, chrunkStartT[j], chrunkEndT[j]);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(nativeSqlStr, this.valuesBraceClosePos + 1, nativeSqlStr.length());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sqlStr = stringBuilder.toString();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (parameterList != null || stringBuilder.length() == lengthT) : "Predicted length != actual: " + lengthT + " !=" + stringBuilder.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sqlStr;
    }

    @Override
    public String toString(ParameterList parameterList) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getBatchSize() < 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return super.toString(parameterList);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.buildNativeSql(parameterList);
    }
}

