/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SCPClient {
    Connection conn;

    public SCPClient(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = conn;
    }

    private void readResponse(InputStream is) throws IOException {
        int c = is.read();
        if (c == 0) {
            return;
        }
        if (c == -1) {
            throw new IOException("Remote scp terminated unexpectedly.");
        }
        if (c != 1 && c != 2) {
            throw new IOException("Remote scp sent illegal error code.");
        }
        if (c == 2) {
            throw new IOException("Remote scp terminated with error.");
        }
        String err = this.receiveLine(is);
        throw new IOException("Remote scp terminated with error (" + err + ").");
    }

    private String receiveLine(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer(30);
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote scp sent a too long line");
            }
            int c = is.read();
            if (c < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private LenNamePair parseCLine(String line) throws IOException {
        long len;
        if (line.length() < 8) {
            throw new IOException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (line.charAt(4) != ' ' || line.charAt(5) == ' ') {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        int length_name_sep = line.indexOf(32, 5);
        if (length_name_sep == -1) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        String length_substring = line.substring(5, length_name_sep);
        String name_substring = line.substring(length_name_sep + 1);
        if (length_substring.length() <= 0 || name_substring.length() <= 0) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + length_substring.length() + name_substring.length() != line.length()) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        try {
            len = Long.parseLong(length_substring);
        }
        catch (NumberFormatException e) {
            throw new IOException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (len < 0L) {
            throw new IOException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        LenNamePair lnp = new LenNamePair();
        lnp.length = len;
        lnp.filename = name_substring;
        return lnp;
    }

    private void sendBytes(Session sess, byte[] data, String fileName, String mode) throws IOException {
        OutputStream os = sess.getStdin();
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 512);
        this.readResponse(is);
        String cline = "C" + mode + " " + data.length + " " + fileName + "\n";
        os.write(cline.getBytes());
        os.flush();
        this.readResponse(is);
        os.write(data, 0, data.length);
        os.write(0);
        os.flush();
        this.readResponse(is);
        os.write("E\n".getBytes());
        os.flush();
    }

    private void sendFiles(Session sess, String[] files, String mode) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(sess.getStdin(), 40000);
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 512);
        this.readResponse(is);
        int i = 0;
        while (i < files.length) {
            File f = new File(files[i]);
            long remain = f.length();
            String cline = "C" + mode + " " + remain + " " + f.getName() + "\n";
            ((OutputStream)os).write(cline.getBytes());
            ((OutputStream)os).flush();
            this.readResponse(is);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                while (remain > 0L) {
                    int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                    if (fis.read(buffer, 0, trans) != trans) {
                        throw new IOException("Cannot read enough from local file " + files[i]);
                    }
                    ((OutputStream)os).write(buffer, 0, trans);
                    remain -= (long)trans;
                }
                fis.close();
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
                throw e;
            }
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            this.readResponse(is);
            ++i;
        }
        ((OutputStream)os).write("E\n".getBytes());
        ((OutputStream)os).flush();
    }

    private void receiveFiles(Session sess, String[] files, String target) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(sess.getStdin(), 512);
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 40000);
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        int i = 0;
        while (i < files.length) {
            String line;
            int c;
            LenNamePair lnp = null;
            do {
                if ((c = ((InputStream)is).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                line = this.receiveLine(is);
            } while (c == 80);
            if (c == 1 || c == 2) {
                throw new IOException("Remote SCP error: " + line);
            }
            if (c != 67) {
                throw new IOException("Remote SCP error: " + (char)c + line);
            }
            lnp = this.parseCLine(line);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            File f = new File(String.valueOf(target) + File.separatorChar + lnp.filename);
            FileOutputStream fop = null;
            try {
                fop = new FileOutputStream(f);
                long remain = lnp.length;
                while (remain > 0L) {
                    int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                    int this_time_received = ((InputStream)is).read(buffer, 0, trans);
                    if (this_time_received < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    fop.write(buffer, 0, this_time_received);
                    remain -= (long)this_time_received;
                }
                fop.close();
            }
            catch (IOException e) {
                if (fop != null) {
                    fop.close();
                }
                throw e;
            }
            this.readResponse(is);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            ++i;
        }
    }

    public void put(String localFile, String remoteTargetDirectory) throws IOException {
        this.put(new String[]{localFile}, remoteTargetDirectory, "0600");
    }

    public void put(String[] localFiles, String remoteTargetDirectory) throws IOException {
        this.put(localFiles, remoteTargetDirectory, "0600");
    }

    public void put(String localFile, String remoteTargetDirectory, String mode) throws IOException {
        this.put(new String[]{localFile}, remoteTargetDirectory, mode);
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory) throws IOException {
        this.put(data, remoteFileName, remoteTargetDirectory, "0600");
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory, String mode) throws IOException {
        Session sess = null;
        if (remoteFileName == null || remoteTargetDirectory == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        int i = 0;
        while (i < mode.length()) {
            if (!Character.isDigit(mode.charAt(i))) {
                throw new IllegalArgumentException("Invalid mode.");
            }
            ++i;
        }
        String cmd = "scp -t -d " + remoteTargetDirectory;
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.sendBytes(sess, data, remoteFileName, mode);
            sess.close();
        }
        catch (IOException e) {
            if (sess != null) {
                sess.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(e);
        }
    }

    public void put(String[] localFiles, String remoteTargetDirectory, String mode) throws IOException {
        Session sess = null;
        if (localFiles == null || remoteTargetDirectory == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        int i = 0;
        while (i < mode.length()) {
            if (!Character.isDigit(mode.charAt(i))) {
                throw new IllegalArgumentException("Invalid mode.");
            }
            ++i;
        }
        if (localFiles.length == 0) {
            return;
        }
        String cmd = "scp -t -d " + remoteTargetDirectory;
        int i2 = 0;
        while (i2 < localFiles.length) {
            if (localFiles[i2] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            ++i2;
        }
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.sendFiles(sess, localFiles, mode);
            sess.close();
        }
        catch (IOException e) {
            if (sess != null) {
                sess.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(e);
        }
    }

    public void get(String remoteFile, String localTargetDirectory) throws IOException {
        this.get(new String[]{remoteFile}, localTargetDirectory);
    }

    public void get(String[] remoteFiles, String localTargetDirectory) throws IOException {
        Session sess = null;
        if (remoteFiles == null || localTargetDirectory == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (remoteFiles.length == 0) {
            return;
        }
        String cmd = "scp -f";
        int i = 0;
        while (i < remoteFiles.length) {
            if (remoteFiles[i] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            cmd = String.valueOf(cmd) + " " + remoteFiles[i];
            ++i;
        }
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.receiveFiles(sess, remoteFiles, localTargetDirectory);
            sess.close();
        }
        catch (IOException e) {
            if (sess != null) {
                sess.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(e);
        }
    }

    class LenNamePair {
        long length;
        String filename;

        LenNamePair() {
        }
    }
}

