/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.examples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;
import ca.uhn.hl7v2.validation.impl.NoValidation;

public class MessageValidation {
    public static void main(String[] args) throws EncodingNotSupportedException {
        String validMessage = "MSH|^~\\&|MedSeries|CAISI_1-2|PLS|3910|200903230934||ADT^A31^ADT_A05|75535037-1237815294895|P^T|2.4\r\nEVN|A31|200903230934\r\nPID|1||29^^CAISI_1-2^PI~\"\"||Test300^Leticia^^^^^L||19770202|M||||||||||||||||||||||";
        PipeParser parser = new PipeParser();
        DefaultValidation defaultValidation = new DefaultValidation();
        parser.setValidationContext((ValidationContext)defaultValidation);
        try {
            parser.parse(validMessage);
            System.out.println("Successfully parsed valid message");
        }
        catch (HL7Exception e) {
            System.out.println("Something went wrong!");
            System.exit(-1);
        }
        String invalidMessage = "MSH|^~\\&|MedSeries|CAISI_1-2|PLS|3910|200903230934||ADT^A31^ADT_A05|75535037-1237815294895|P^T|2.4\r\nEVN|0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789|200903230934\r\nPID|1||29^^CAISI_1-2^PI~\"\"||Test300^Leticia^^^^^L||19770202|M||||||||||||||||||||||";
        try {
            parser.parse(invalidMessage);
            System.out.println("Something went wrong!");
            System.exit(-1);
        }
        catch (HL7Exception e) {
            System.out.println("As expected, the message did not validate: " + e.getMessage());
        }
        NoValidation noValidation = new NoValidation();
        parser.setValidationContext((ValidationContext)noValidation);
        try {
            parser.parse(invalidMessage);
            System.out.println("Successfully parsed invalid message");
        }
        catch (HL7Exception e) {
            System.out.println("Something went wrong!");
            System.exit(-1);
        }
        invalidMessage = "MSH|^~\\&|MedSeries|CAISI_1-2|PLS|3910|200903230934||ADT^A31^ADT_A05|             CONTROLID|P^T|2.4\r\nEVN|A03|200903230934\r\nPID|1||29^^CAISI_1-2^PI~\"\"||Test300^Leticia^^^^^L||19770202|M||||||||||||||||||||||";
        try {
            Message parsedMessage = parser.parse(invalidMessage);
            System.out.println(new PipeParser().encode(parsedMessage));
        }
        catch (HL7Exception e) {
            e.printStackTrace();
        }
    }
}

