/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import java.util.ArrayList;

public class WrongVersionRule
extends AbstractMessageRule {
    public static final MessageRule WRONG_VERSION = new WrongVersionRule();

    @Override
    public ValidationException[] apply(Message msg) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        ValidationException ve = new ValidationException("Invalid version: " + msg.getVersion());
        Location location = new Location().withSegmentName("MSH").withField(12);
        ve.setLocation(location);
        ve.setError(ErrorCode.UNSUPPORTED_VERSION_ID);
        exceptions.add(ve);
        return exceptions.toArray(new ValidationException[exceptions.size()]);
    }
}

