/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util.idgenerator;

import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiLoGenerator
extends IDGenerator.OrderedSupport {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiLoGenerator.class.getName());
    private long lo = 0L;
    private long base = -1L;

    @Override
    public synchronized String getID() throws IOException {
        if (this.base < 0L) {
            LOG.debug("Obtain next hi ID");
            this.base = this.nextBase();
        }
        if (this.getNextLoId() >= this.getMaxLo()) {
            LOG.debug("Obtain next hi ID");
            this.base = this.nextBase();
        }
        return Long.toString(this.base + this.lo);
    }

    private long nextBase() throws IOException {
        long base = this.getNextHiId();
        this.lo = 0L;
        return base;
    }

    protected abstract long getNextHiId() throws IOException;

    protected abstract void resetHiId();

    protected long getNextLoId() {
        return ++this.lo;
    }

    @Override
    public void reset() {
        this.lo = 0L;
        this.base = -1L;
        this.resetHiId();
    }

    public abstract long getMaxLo();
}

