/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.HapiContextSupport;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.util.Hl7InputStreamMessageStringIterator;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;

public class Hl7InputStreamMessageIterator
extends HapiContextSupport
implements Iterator<Message> {
    private Class<? extends Message> myMessageType;
    private Hl7InputStreamMessageStringIterator myWrapped;

    public Hl7InputStreamMessageIterator(InputStream theInputStream) {
        this(theInputStream, (HapiContext)new DefaultHapiContext(ValidationContextFactory.noValidation()));
    }

    public Hl7InputStreamMessageIterator(Reader theReader) {
        this(theReader, (HapiContext)new DefaultHapiContext(ValidationContextFactory.noValidation()));
    }

    public Hl7InputStreamMessageIterator(InputStream theInputStream, HapiContext theHapiContext) {
        super(theHapiContext);
        this.myWrapped = new Hl7InputStreamMessageStringIterator(theInputStream);
    }

    public Hl7InputStreamMessageIterator(Reader theReader, HapiContext theHapiContext) {
        super(theHapiContext);
        this.myWrapped = new Hl7InputStreamMessageStringIterator(theReader);
    }

    public static Hl7InputStreamMessageIterator getForClasspathResource(String theClasspath) {
        InputStream is = Hl7InputStreamMessageIterator.class.getResourceAsStream(theClasspath);
        if (is == null) {
            throw new IllegalArgumentException("Can't find resource: " + theClasspath);
        }
        return new Hl7InputStreamMessageIterator(is);
    }

    @Override
    public boolean hasNext() {
        return this.myWrapped.hasNext();
    }

    @Override
    public Message next() {
        Message retVal;
        String nextString = this.myWrapped.next();
        try {
            if (this.myMessageType != null) {
                retVal = ReflectionUtil.instantiateMessage(this.myMessageType, this.getHapiContext().getModelClassFactory());
                retVal.parse(nextString);
            } else {
                retVal = this.getHapiContext().getPipeParser().parse(nextString);
            }
        }
        catch (EncodingNotSupportedException e) {
            throw new Hl7InputStreamMessageStringIterator.ParseFailureError("Failed to parse message", e);
        }
        catch (HL7Exception e) {
            throw new Hl7InputStreamMessageStringIterator.ParseFailureError("Failed to parse message", e);
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setIgnoreComments(boolean theIgnoreComments) {
        this.myWrapped.setIgnoreComments(theIgnoreComments);
    }

    public void setMessageType(Class<? extends Message> theMessageType) {
        this.myMessageType = theMessageType;
    }
}

