/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.Initiator;
import ca.uhn.hl7v2.protocol.Processor;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InitiatorImpl
implements Initiator {
    private final List<String> myMetadataFields = new ArrayList<String>(20);
    private final Parser myParser;
    private final Processor myProcessor;
    private int myMaxRetries;
    private long myRetryInterval;
    private long myReceiveTimeout;

    public InitiatorImpl(Processor theProcessor) {
        this.myMetadataFields.add("MSH-18");
        this.myParser = new GenericParser();
        this.myProcessor = theProcessor;
        this.init();
    }

    public InitiatorImpl(Parser theParser, Processor theProcessor) {
        this.myParser = theParser;
        this.myProcessor = theProcessor;
        this.init();
    }

    private void init() {
        this.myMaxRetries = 3;
        this.myRetryInterval = 3000L;
        this.myReceiveTimeout = 10000L;
    }

    public void setMaxRetries(int theMaxRetries) {
        this.myMaxRetries = theMaxRetries;
    }

    public int getMaxRetries() {
        return this.myMaxRetries;
    }

    public void setRetryInterval(long theRetryIntervalMillis) {
        this.myRetryInterval = theRetryIntervalMillis;
    }

    public long getRetryInterval() {
        return this.myRetryInterval;
    }

    public void setReceiveTimeout(long theReceiveTimeout) {
        this.myReceiveTimeout = theReceiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.myReceiveTimeout;
    }

    @Override
    public Message sendAndReceive(Message theMessage) throws HL7Exception {
        Transportable received;
        Terser t = new Terser(theMessage);
        String appAckNeeded = t.get("/MSH-16");
        String msgId = t.get("/MSH-10");
        String messageText = this.getParser().encode(theMessage);
        Map<String, Object> metadata = this.getMetadata(theMessage);
        TransportableImpl out = new TransportableImpl(messageText, metadata);
        if (this.needAck(appAckNeeded)) {
            this.myProcessor.reserve(msgId, this.getReceiveTimeout());
        }
        this.myProcessor.send(out, this.getMaxRetries(), this.getRetryInterval());
        Message in = null;
        if (this.needAck(appAckNeeded) && (received = this.myProcessor.receive(msgId, this.getReceiveTimeout())) != null && received.getMessage() != null) {
            in = this.getParser().parse(received.getMessage());
        }
        return in;
    }

    private boolean needAck(String theAckCode) {
        boolean need = false;
        if (theAckCode == null || theAckCode.equals("") || theAckCode.equals("AL") || theAckCode.equals("ER")) {
            need = true;
        }
        return need;
    }

    private Map<String, Object> getMetadata(Message theMessage) throws HL7Exception {
        HashMap<String, Object> md = new HashMap<String, Object>();
        Terser t = new Terser(theMessage);
        String[] fields = this.getMetadataFields().toArray(new String[0]);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].toString();
            String val = t.get(field);
            md.put(field, val);
        }
        return md;
    }

    @Override
    public Parser getParser() {
        return this.myParser;
    }

    @Override
    public Processor getUnderlyingProcessor() {
        return this.myProcessor;
    }

    @Override
    public List<String> getMetadataFields() {
        return this.myMetadataFields;
    }
}

