/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationExceptionHandler;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.ParseChecker;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRouterImpl
implements ApplicationRouter {
    public static final AcknowledgmentCode DEFAULT_EXCEPTION_ACKNOWLEDGEMENT_CODE = AcknowledgmentCode.AE;
    private static final Logger log = LoggerFactory.getLogger(ApplicationRouterImpl.class);
    public static final String RAW_MESSAGE_KEY = "raw-message";
    private List<Binding> myBindings;
    private Parser myParser;
    private ReceivingApplicationExceptionHandler myExceptionHandler;
    private HapiContext myContext;
    private AcknowledgmentCode defaultAcknowledgementMode = DEFAULT_EXCEPTION_ACKNOWLEDGEMENT_CODE;

    @Deprecated
    public ApplicationRouterImpl() {
        this(new GenericParser());
    }

    public ApplicationRouterImpl(Parser theParser) {
        this(theParser.getHapiContext(), theParser);
    }

    public ApplicationRouterImpl(HapiContext theContext) {
        this(theContext, theContext.getGenericParser());
    }

    public ApplicationRouterImpl(HapiContext theContext, Parser theParser) {
        this.init(theParser);
        this.myContext = theContext;
    }

    private void init(Parser theParser) {
        this.myBindings = new ArrayList<Binding>(20);
        this.myParser = theParser;
    }

    public void setDefaultAcknowledgementMode(AcknowledgmentCode defaultAcknowledgementMode) {
        this.defaultAcknowledgementMode = defaultAcknowledgementMode;
    }

    @Override
    public Transportable processMessage(Transportable theMessage) throws HL7Exception {
        String[] result = this.processMessage(theMessage.getMessage(), theMessage.getMetadata());
        TransportableImpl response = new TransportableImpl(result[0]);
        if (result[1] != null) {
            response.getMetadata().put("MSH-18", result[1]);
        }
        return response;
    }

    private String[] processMessage(String incomingMessageString, Map<String, Object> theMetadata) throws HL7Exception {
        String outgoingMessageCharset;
        String outgoingMessageString;
        Message incomingMessageObject;
        Logger rawOutbound;
        block9: {
            rawOutbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.outbound");
            Logger rawInbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.inbound");
            log.debug("ApplicationRouterImpl got message: {}", (Object)incomingMessageString);
            rawInbound.debug(incomingMessageString);
            incomingMessageObject = null;
            outgoingMessageString = null;
            outgoingMessageCharset = null;
            try {
                incomingMessageObject = this.myParser.parse(incomingMessageString);
                Terser inTerser = new Terser(incomingMessageObject);
                theMetadata.put("/MSH-10", inTerser.get("/.MSH-10"));
            }
            catch (HL7Exception e) {
                log.debug("Exception parsing incoming message", (Throwable)e);
                try {
                    outgoingMessageString = this.logAndMakeErrorMessage(e, this.myParser.getCriticalResponseData(incomingMessageString), this.myParser, this.myParser.getEncoding(incomingMessageString));
                }
                catch (HL7Exception e2) {
                    log.error("Exception occurred while logging parse failure", (Throwable)e2);
                    outgoingMessageString = null;
                }
                if (this.myExceptionHandler == null || (outgoingMessageString = this.myExceptionHandler.processException(incomingMessageString, theMetadata, outgoingMessageString, e)) != null) break block9;
                throw new HL7Exception("Application exception handler may not return null");
            }
        }
        if (outgoingMessageString == null) {
            try {
                String check = System.getProperty("ca.uhn.hl7v2.protocol.impl.check_parse");
                if (check != null && check.equals("TRUE")) {
                    ParseChecker.checkParse(incomingMessageString, incomingMessageObject, this.myParser);
                }
                ReceivingApplication<Message> app = this.findApplication(incomingMessageObject);
                theMetadata.put(RAW_MESSAGE_KEY, incomingMessageString);
                log.debug("Sending message to application: {}", (Object)app.toString());
                Message response = app.processMessage(incomingMessageObject, theMetadata);
                outgoingMessageString = this.myParser.encode(response, this.myParser.getEncoding(incomingMessageString));
                Terser t = new Terser(response);
                outgoingMessageCharset = t.get("MSH-18");
            }
            catch (Exception e) {
                outgoingMessageString = this.handleProcessMessageException(incomingMessageString, theMetadata, incomingMessageObject, e);
            }
            catch (Error e) {
                log.debug("Caught runtime exception of type {}, going to wrap it as HL7Exception and handle it", e.getClass());
                HL7Exception wrapped = new HL7Exception(e);
                outgoingMessageString = this.handleProcessMessageException(incomingMessageString, theMetadata, incomingMessageObject, wrapped);
            }
        }
        log.debug("ApplicationRouterImpl sending message: {}", (Object)outgoingMessageString);
        rawOutbound.debug(outgoingMessageString);
        return new String[]{outgoingMessageString, outgoingMessageCharset};
    }

    private String handleProcessMessageException(String incomingMessageString, Map<String, Object> theMetadata, Message incomingMessageObject, Exception e) throws HL7Exception {
        Segment inHeader = incomingMessageObject != null ? (Segment)incomingMessageObject.get("MSH") : null;
        String outgoingMessageString = this.logAndMakeErrorMessage(e, inHeader, this.myParser, this.myParser.getEncoding(incomingMessageString));
        if (outgoingMessageString != null && this.myExceptionHandler != null) {
            outgoingMessageString = this.myExceptionHandler.processException(incomingMessageString, theMetadata, outgoingMessageString, e);
        }
        return outgoingMessageString;
    }

    @Override
    public boolean hasActiveBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        boolean result = false;
        ReceivingApplication<Object> app = this.findDestination(null, theRoutingData);
        if (app != null) {
            result = true;
        }
        return result;
    }

    private <T extends Message> ReceivingApplication<T> findDestination(T theMessage, ApplicationRouter.AppRoutingData theRoutingData) {
        ReceivingApplication<? extends Message> result = null;
        for (int i = 0; i < this.myBindings.size() && result == null; ++i) {
            Binding binding = this.myBindings.get(i);
            if (!ApplicationRouterImpl.matches(theRoutingData, binding.routingData) || !binding.active || theMessage != null && !binding.application.canProcess(theMessage)) continue;
            result = binding.application;
        }
        return result;
    }

    private Binding findBinding(ReceivingApplication<? extends Message> application) {
        Binding result = null;
        for (int i = 0; i < this.myBindings.size() && result == null; ++i) {
            Binding binding = this.myBindings.get(i);
            if (application != binding.application) continue;
            result = binding;
        }
        return result;
    }

    private Binding findBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding result = null;
        for (int i = 0; i < this.myBindings.size() && result == null; ++i) {
            Binding binding = this.myBindings.get(i);
            if (!theRoutingData.equals(binding.routingData)) continue;
            result = binding;
        }
        return result;
    }

    @Override
    public void bindApplication(ApplicationRouter.AppRoutingData theRoutingData, ReceivingApplication<? extends Message> theApplication) {
        Binding binding = new Binding(theRoutingData, true, theApplication);
        this.myBindings.add(binding);
    }

    @Override
    public boolean unbindApplication(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        return b != null && this.myBindings.remove(b);
    }

    @Override
    public boolean unbindApplication(ReceivingApplication<? extends Message> theApplication) {
        Binding b = this.findBinding(theApplication);
        return b != null && this.myBindings.remove(b);
    }

    @Override
    public void disableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = false;
        }
    }

    @Override
    public void enableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = true;
        }
    }

    @Override
    public Parser getParser() {
        return this.myParser;
    }

    @Override
    public void setExceptionHandler(ReceivingApplicationExceptionHandler theExceptionHandler) {
        this.myExceptionHandler = theExceptionHandler;
    }

    public static boolean matches(ApplicationRouter.AppRoutingData theMessageData, ApplicationRouter.AppRoutingData theReferenceData) {
        boolean result = false;
        if (ApplicationRouterImpl.matches(theMessageData.getMessageType(), theReferenceData.getMessageType()) && ApplicationRouterImpl.matches(theMessageData.getTriggerEvent(), theReferenceData.getTriggerEvent()) && ApplicationRouterImpl.matches(theMessageData.getProcessingId(), theReferenceData.getProcessingId()) && ApplicationRouterImpl.matches(theMessageData.getVersion(), theReferenceData.getVersion())) {
            result = true;
        }
        return result;
    }

    private static boolean matches(String theMessageData, String theReferenceData) {
        boolean result = false;
        String messageData = theMessageData;
        if (messageData == null) {
            messageData = "";
        }
        if (messageData.equals(theReferenceData) || theReferenceData.equals("*") || Pattern.matches(theReferenceData, messageData)) {
            result = true;
        }
        return result;
    }

    private <T extends Message> ReceivingApplication<T> findApplication(T theMessage) throws HL7Exception {
        Terser t = new Terser(theMessage);
        AppRoutingDataImpl msgData = new AppRoutingDataImpl(t.get("/MSH-9-1"), t.get("/MSH-9-2"), t.get("/MSH-11-1"), t.get("/MSH-12"));
        DefaultApplication app = this.findDestination(theMessage, msgData);
        if (app == null) {
            app = new DefaultApplication();
        }
        return app;
    }

    public String logAndMakeErrorMessage(Exception e, Segment inHeader, Parser p, String encoding) throws HL7Exception {
        switch (this.myContext.getServerConfiguration().getApplicationExceptionPolicy()) {
            case DO_NOT_RESPOND: {
                log.error("Application exception detected, not going to send a response back to the client", (Throwable)e);
                return null;
            }
        }
        log.error("Attempting to send error message to remote system.", (Throwable)e);
        HL7Exception hl7e = e instanceof HL7Exception ? (HL7Exception)e : new HL7Exception(e.getMessage(), e);
        try {
            Message out = hl7e.getResponseMessage();
            if (out == null) {
                Message in = this.getInMessage(inHeader);
                out = in.generateACK(this.defaultAcknowledgementMode, hl7e);
            }
            return encoding != null ? p.encode(out, encoding) : p.encode(out);
        }
        catch (IOException ioe) {
            throw new HL7Exception("IOException creating error response message: " + ioe.getMessage());
        }
    }

    private Message getInMessage(Segment inHeader) throws HL7Exception, IOException {
        Message in;
        if (inHeader != null) {
            in = inHeader.getMessage();
            DeepCopy.copy(inHeader, (Segment)in.get("MSH"));
        } else {
            in = Version.highestAvailableVersionOrDefault().newGenericMessage(this.myParser.getFactory());
            ((GenericMessage)in).initQuickstart("ACK", "", "");
        }
        return in;
    }

    private static class Binding {
        public ApplicationRouter.AppRoutingData routingData;
        public boolean active;
        public ReceivingApplication<? extends Message> application;

        public Binding(ApplicationRouter.AppRoutingData theRoutingData, boolean isActive, ReceivingApplication<? extends Message> theApplication) {
            this.routingData = theRoutingData;
            this.active = isActive;
            this.application = theApplication;
        }
    }
}

