/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.check;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.HapiContextSupport;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.ProfileNotFollowedException;
import ca.uhn.hl7v2.conf.check.ProfileNotHL7CompliantException;
import ca.uhn.hl7v2.conf.check.Validator;
import ca.uhn.hl7v2.conf.check.XElementPresentException;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.conf.spec.message.AbstractComponent;
import ca.uhn.hl7v2.conf.spec.message.AbstractSegmentContainer;
import ca.uhn.hl7v2.conf.spec.message.Component;
import ca.uhn.hl7v2.conf.spec.message.Field;
import ca.uhn.hl7v2.conf.spec.message.ProfileStructure;
import ca.uhn.hl7v2.conf.spec.message.Seg;
import ca.uhn.hl7v2.conf.spec.message.SegGroup;
import ca.uhn.hl7v2.conf.spec.message.StaticDef;
import ca.uhn.hl7v2.conf.spec.message.SubComponent;
import ca.uhn.hl7v2.conf.store.CodeStore;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidator
extends HapiContextSupport
implements Validator {
    private EncodingCharacters enc = new EncodingCharacters('|', null);
    private static final Logger log = LoggerFactory.getLogger(DefaultValidator.class);
    private boolean validateChildren = true;
    private CodeStore codeStore;

    public DefaultValidator() {
        this(new DefaultHapiContext());
    }

    public DefaultValidator(HapiContext context) {
        super(context);
    }

    public void setValidateChildren(boolean validateChildren) {
        this.validateChildren = validateChildren;
    }

    public void setCodeStore(CodeStore theCodeStore) {
        this.codeStore = theCodeStore;
    }

    @Override
    public HL7Exception[] validate(Message message, StaticDef profile) throws ProfileException, HL7Exception {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        Terser t = new Terser(message);
        this.checkMessageType(t.get("/MSH-9-1"), profile, exList);
        this.checkEventType(t.get("/MSH-9-2"), profile, exList);
        this.checkMessageStructure(t.get("/MSH-9-3"), profile, exList);
        exList.addAll(this.doTestGroup(message, profile, profile.getIdentifier(), this.validateChildren));
        return exList.toArray(new HL7Exception[exList.size()]);
    }

    protected void checkEventType(String evType, StaticDef profile, List<HL7Exception> exList) throws HL7Exception {
        if (!evType.equals(profile.getEventType()) && !profile.getEventType().equalsIgnoreCase("ALL")) {
            ProfileNotFollowedException e = new ProfileNotFollowedException("Event type " + evType + " doesn't match profile type of " + profile.getEventType());
            exList.add(e);
        }
    }

    protected void checkMessageType(String msgType, StaticDef profile, List<HL7Exception> exList) throws HL7Exception {
        if (!msgType.equals(profile.getMsgType())) {
            ProfileNotFollowedException e = new ProfileNotFollowedException("Message type " + msgType + " doesn't match profile type of " + profile.getMsgType());
            exList.add(e);
        }
    }

    protected void checkMessageStructure(String msgStruct, StaticDef profile, List<HL7Exception> exList) {
        if (msgStruct == null || !msgStruct.equals(profile.getMsgStructID())) {
            ProfileNotFollowedException e = new ProfileNotFollowedException("Message structure " + msgStruct + " doesn't match profile type of " + profile.getMsgStructID());
            exList.add(e);
        }
    }

    public List<HL7Exception> testGroup(Group group, SegGroup profile, String profileID) throws ProfileException {
        return this.doTestGroup(group, profile, profileID, true);
    }

    protected List<HL7Exception> doTestGroup(Group group, AbstractSegmentContainer profile, String profileID, boolean theValidateChildren) throws ProfileException {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        ArrayList<String> allowedStructures = new ArrayList<String>();
        for (ProfileStructure struct : profile) {
            if (struct.getUsage().equalsIgnoreCase("X")) continue;
            allowedStructures.add(struct.getName());
            try {
                ArrayList<Structure> instancesWithContent = new ArrayList<Structure>();
                for (Structure instance : group.getAll(struct.getName())) {
                    if (instance.isEmpty()) continue;
                    instancesWithContent.add(instance);
                }
                this.testCardinality(instancesWithContent.size(), struct.getMin(), struct.getMax(), struct.getUsage(), struct.getName(), exList);
                if (!theValidateChildren) continue;
                for (Structure s : instancesWithContent) {
                    exList.addAll(this.testStructure(s, struct, profileID));
                }
            }
            catch (HL7Exception he) {
                exList.add(new ProfileNotHL7CompliantException(struct.getName() + " not found in message"));
            }
        }
        this.checkForExtraStructures(group, allowedStructures, exList);
        return exList;
    }

    protected void checkForExtraStructures(Group group, List<String> allowedStructures, List<HL7Exception> exList) throws ProfileException {
        for (String childName : group.getNames()) {
            if (allowedStructures.contains(childName)) continue;
            try {
                for (Structure rep : group.getAll(childName)) {
                    if (rep.isEmpty()) continue;
                    XElementPresentException e = new XElementPresentException("The structure " + childName + " appears in the message but not in the profile");
                    exList.add(e);
                }
            }
            catch (HL7Exception he) {
                throw new ProfileException("Problem checking profile", he);
            }
        }
    }

    protected HL7Exception testCardinality(int reps, int min, int max, String usage, String name, List<HL7Exception> exList) {
        ProfileNotFollowedException e = null;
        if (reps < min && usage.equalsIgnoreCase("R")) {
            e = new ProfileNotFollowedException(name + " must have at least " + min + " repetitions (has " + reps + ")");
        } else if (max > 0 && reps > max) {
            e = new ProfileNotFollowedException(name + " must have no more than " + max + " repetitions (has " + reps + ")");
        }
        if (e != null) {
            exList.add(e);
        }
        return e;
    }

    public List<HL7Exception> testStructure(Structure s, ProfileStructure profile, String profileID) throws ProfileException {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        if (profile instanceof Seg) {
            if (Segment.class.isAssignableFrom(s.getClass())) {
                exList.addAll(this.doTestSegment((Segment)s, (Seg)profile, profileID, this.validateChildren));
            } else {
                exList.add(new ProfileNotHL7CompliantException("Mismatch between a segment in the profile and the structure " + s.getClass().getName() + " in the message"));
            }
        } else if (profile instanceof SegGroup) {
            if (Group.class.isAssignableFrom(s.getClass())) {
                exList.addAll(this.testGroup((Group)s, (SegGroup)profile, profileID));
            } else {
                exList.add(new ProfileNotHL7CompliantException("Mismatch between a group in the profile and the structure " + s.getClass().getName() + " in the message"));
            }
        }
        return exList;
    }

    public List<HL7Exception> testSegment(Segment segment, Seg profile, String profileID) throws ProfileException {
        return this.doTestSegment(segment, profile, profileID, true);
    }

    protected List<HL7Exception> doTestSegment(Segment segment, Seg profile, String profileID, boolean theValidateChildren) throws ProfileException {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        ArrayList<Integer> allowedFields = new ArrayList<Integer>();
        for (int i = 1; i <= profile.getFields(); ++i) {
            Field field = profile.getField(i);
            if (field.getUsage().equalsIgnoreCase("X")) continue;
            allowedFields.add(i);
            try {
                Type[] instances = segment.getField(i);
                ArrayList<Type> instancesWithContent = new ArrayList<Type>();
                for (Type instance : instances) {
                    if (instance.isEmpty()) continue;
                    instancesWithContent.add(instance);
                }
                HL7Exception ce = this.testCardinality(instancesWithContent.size(), field.getMin(), field.getMax(), field.getUsage(), field.getName(), exList);
                if (ce != null) {
                    ce.setFieldPosition(i);
                }
                if (!theValidateChildren) continue;
                for (Type s : instancesWithContent) {
                    boolean escape = !profile.getName().equalsIgnoreCase("MSH") || i >= 3;
                    List<HL7Exception> childExceptions = this.doTestField(s, field, escape, profileID, this.validateChildren);
                    for (HL7Exception ex : childExceptions) {
                        ex.setFieldPosition(i);
                    }
                    exList.addAll(childExceptions);
                }
                continue;
            }
            catch (HL7Exception he) {
                exList.add(new ProfileNotHL7CompliantException("Field " + i + " not found in message"));
            }
        }
        this.checkForExtraFields(segment, allowedFields, exList);
        for (HL7Exception ex : exList) {
            ex.setSegmentName(profile.getName());
        }
        return exList;
    }

    protected void checkForExtraFields(Segment segment, List<Integer> allowedFields, List<HL7Exception> exList) throws ProfileException {
        for (int i = 1; i <= segment.numFields(); ++i) {
            if (allowedFields.contains(i)) continue;
            try {
                Type[] reps;
                for (Type rep : reps = segment.getField(i)) {
                    if (rep.isEmpty()) continue;
                    XElementPresentException e = new XElementPresentException("Field " + i + " in " + segment.getName() + " appears in the message but not in the profile");
                    exList.add(e);
                }
                continue;
            }
            catch (HL7Exception he) {
                throw new ProfileException("Problem testing against profile", he);
            }
        }
    }

    public List<HL7Exception> testType(Type type, AbstractComponent<?> profile, String encoded, String profileID) {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        if (encoded == null) {
            encoded = PipeParser.encode(type, this.enc);
        }
        this.testUsage(encoded, profile.getUsage(), profile.getName(), exList);
        if (!profile.getUsage().equals("X")) {
            this.checkDataType(profile.getDatatype(), type, exList);
            this.checkLength(profile.getLength(), profile.getName(), encoded, exList);
            this.checkConstantValue(profile.getConstantValue(), encoded, exList);
            this.testTypeAgainstTable(type, profile, profileID, exList);
        }
        return exList;
    }

    protected void checkConstantValue(String value, String encoded, List<HL7Exception> exList) {
        if (value != null && value.length() > 0 && !encoded.equals(value)) {
            exList.add(new ProfileNotFollowedException("'" + encoded + "' doesn't equal constant value of '" + value + "'"));
        }
    }

    protected void checkLength(long length, String name, String encoded, List<HL7Exception> exList) {
        if ((long)encoded.length() > length) {
            exList.add(new ProfileNotFollowedException("The type " + name + " has length " + encoded.length() + " which exceeds max of " + length));
        }
    }

    protected void checkDataType(String dataType, Type type, List<HL7Exception> exList) {
        String typeName = type.getName();
        if (!(type instanceof Varies) && !typeName.equals(dataType)) {
            exList.add(new ProfileNotHL7CompliantException("HL7 datatype " + typeName + " doesn't match profile datatype " + dataType));
        }
    }

    public HL7Exception testLength(Type type, int maxLength) {
        ProfileNotFollowedException e = null;
        String encoded = PipeParser.encode(type, this.enc);
        if (encoded.length() > maxLength) {
            e = new ProfileNotFollowedException("Length of " + encoded.length() + " exceeds maximum of " + maxLength);
        }
        return e;
    }

    protected void testUsage(String encoded, String usage, String name, List<HL7Exception> exList) {
        if (usage.equalsIgnoreCase("R")) {
            if (encoded.length() == 0) {
                exList.add(new ProfileNotFollowedException("Required element " + name + " is missing"));
            }
        } else if (!(usage.equalsIgnoreCase("RE") || usage.equalsIgnoreCase("O") || usage.equalsIgnoreCase("C") || usage.equalsIgnoreCase("CE"))) {
            if (usage.equalsIgnoreCase("X")) {
                if (encoded.length() > 0) {
                    exList.add(new XElementPresentException("Element \"" + name + "\" is present but specified as not used (X)"));
                }
            } else if (usage.equalsIgnoreCase("B")) {
                // empty if block
            }
        }
    }

    protected void testTypeAgainstTable(Type type, AbstractComponent<?> profile, String profileID, List<HL7Exception> exList) {
        if (profile.getTable() != null && (type.getName().equals("IS") || type.getName().equals("ID"))) {
            String codeSystem = String.format("HL7%1$4s", profile.getTable()).replace(" ", "0");
            String value = ((Primitive)type).getValue();
            this.addTableTestResult(profileID, codeSystem, value, exList);
        } else if (type.getName().equals("CE")) {
            String value = Terser.getPrimitive(type, 1, 1).getValue();
            String codeSystem = Terser.getPrimitive(type, 3, 1).getValue();
            this.addTableTestResult(profileID, codeSystem, value, exList);
            value = Terser.getPrimitive(type, 4, 1).getValue();
            codeSystem = Terser.getPrimitive(type, 6, 1).getValue();
            this.addTableTestResult(profileID, codeSystem, value, exList);
        }
    }

    protected void addTableTestResult(String profileID, String codeSystem, String value, List<HL7Exception> exList) {
        if (codeSystem != null && value != null && this.validateChildren) {
            this.testValueAgainstTable(profileID, codeSystem, value, exList);
        }
    }

    protected void testValueAgainstTable(String profileID, String codeSystem, String value, List<HL7Exception> exList) {
        CodeStore store = this.codeStore;
        if (this.codeStore == null) {
            store = this.getHapiContext().getCodeStoreRegistry().getCodeStore(profileID, codeSystem);
        }
        if (store == null) {
            log.info("Not checking value {}: no code store was found for profile {} code system {}", new Object[]{value, profileID, codeSystem});
        } else if (!store.knowsCodes(codeSystem)) {
            log.warn("Not checking value {}: Don't have a table for code system {}", (Object)value, (Object)codeSystem);
        } else if (!store.isValidCode(codeSystem, value)) {
            exList.add(new ProfileNotFollowedException("Code '" + value + "' not found in table " + codeSystem + ", profile " + profileID));
        }
    }

    public List<HL7Exception> testField(Type type, Field profile, boolean escape, String profileID) throws ProfileException, HL7Exception {
        return this.doTestField(type, profile, escape, profileID, true);
    }

    protected List<HL7Exception> doTestField(Type type, Field profile, boolean escape, String profileID, boolean theValidateChildren) throws ProfileException, HL7Exception {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        String encoded = null;
        if (!escape && Primitive.class.isAssignableFrom(type.getClass())) {
            encoded = ((Primitive)type).getValue();
        }
        exList.addAll(this.testType(type, profile, encoded, profileID));
        if (theValidateChildren && profile.getComponents() > 0 && !profile.getUsage().equals("X")) {
            if (Composite.class.isAssignableFrom(type.getClass())) {
                Composite comp = (Composite)type;
                for (int i = 1; i <= profile.getComponents(); ++i) {
                    Component childProfile = profile.getComponent(i);
                    try {
                        Type child = comp.getComponent(i - 1);
                        exList.addAll(this.doTestComponent(child, childProfile, profileID, this.validateChildren));
                        continue;
                    }
                    catch (DataTypeException de) {
                        exList.add(new ProfileNotHL7CompliantException("More components in profile than allowed in message: " + de.getMessage()));
                    }
                }
                this.checkExtraComponents(comp, profile.getComponents(), exList);
            } else {
                exList.add(new ProfileNotHL7CompliantException("A field has type primitive " + type.getClass().getName() + " but the profile defines components"));
            }
        }
        return exList;
    }

    public List<HL7Exception> testComponent(Type type, Component profile, String profileID) throws ProfileException, HL7Exception {
        return this.doTestComponent(type, profile, profileID, true);
    }

    protected List<HL7Exception> doTestComponent(Type type, Component profile, String profileID, boolean theValidateChildren) throws ProfileException, HL7Exception {
        ArrayList<HL7Exception> exList = new ArrayList<HL7Exception>();
        exList.addAll(this.testType(type, profile, null, profileID));
        if (profile.getSubComponents() > 0 && !profile.getUsage().equals("X") && !type.isEmpty()) {
            if (Composite.class.isAssignableFrom(type.getClass())) {
                Composite comp = (Composite)type;
                if (theValidateChildren) {
                    for (int i = 1; i <= profile.getSubComponents(); ++i) {
                        SubComponent childProfile = profile.getSubComponent(i);
                        try {
                            Type child = comp.getComponent(i - 1);
                            exList.addAll(this.testType(child, childProfile, null, profileID));
                            continue;
                        }
                        catch (DataTypeException de) {
                            exList.add(new ProfileNotHL7CompliantException("More subcomponents in profile than allowed in message: " + de.getMessage()));
                        }
                    }
                }
                this.checkExtraComponents(comp, profile.getSubComponents(), exList);
            } else {
                exList.add(new ProfileNotFollowedException("A component has primitive type " + type.getClass().getName() + " but the profile defines subcomponents"));
            }
        }
        return exList;
    }

    protected void checkExtraComponents(Composite comp, int numInProfile, List<HL7Exception> exList) throws ProfileException {
        StringBuilder extra = new StringBuilder();
        for (int i = numInProfile; i < comp.getComponents().length; ++i) {
            try {
                String s = PipeParser.encode(comp.getComponent(i), this.enc);
                if (s.length() <= 0) continue;
                extra.append(s).append(this.enc.getComponentSeparator());
                continue;
            }
            catch (DataTypeException de) {
                throw new ProfileException("Problem testing against profile", de);
            }
        }
        if (extra.length() > 0) {
            exList.add(new XElementPresentException("The following components are not defined in the profile: " + extra.toString()));
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: DefaultValidator message_file profile_file");
            System.exit(1);
        }
        DefaultValidator val = new DefaultValidator();
        try {
            String msgString = DefaultValidator.loadFile(args[0]);
            GenericParser parser = new GenericParser();
            Message message = ((Parser)parser).parse(msgString);
            String profileString = DefaultValidator.loadFile(args[1]);
            ProfileParser profParser = new ProfileParser(true);
            RuntimeProfile profile = profParser.parse(profileString);
            HL7Exception[] exceptions = val.validate(message, profile.getMessage());
            System.out.println("Exceptions: ");
            for (int i = 0; i < exceptions.length; ++i) {
                System.out.println(i + 1 + ". " + exceptions[i].getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String loadFile(String path) throws IOException {
        int c;
        File file = new File(path);
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer buf = new StringBuffer(5000);
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        in.close();
        return buf.toString();
    }
}

