/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.spec.message;

import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.spec.message.ProfileStructure;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public class AbstractSegmentContainer {
    private String description;
    private String reference;
    private String impNote;
    private ProfileStructure[] children;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);

    public AbstractSegmentContainer() {
        this.children = new ProfileStructure[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws ProfileException {
        String oldDescription = this.description;
        try {
            this.vetoableChangeSupport.fireVetoableChange("description", oldDescription, description);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescription, description);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) throws ProfileException {
        String oldReference = this.reference;
        try {
            this.vetoableChangeSupport.fireVetoableChange("reference", oldReference, reference);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.reference = reference;
        this.propertyChangeSupport.firePropertyChange("reference", oldReference, reference);
    }

    public String getImpNote() {
        return this.impNote;
    }

    public void setImpNote(String impNote) throws ProfileException {
        String oldImpNote = this.impNote;
        try {
            this.vetoableChangeSupport.fireVetoableChange("impNote", oldImpNote, impNote);
        }
        catch (Exception e) {
            throw new ProfileException(null, e);
        }
        this.impNote = impNote;
        this.propertyChangeSupport.firePropertyChange("impNote", oldImpNote, impNote);
    }

    public ProfileStructure getChild(int index) {
        return this.children[index - 1];
    }

    public void setChild(int index, ProfileStructure structure) throws ProfileException {
        this.extendChildList(--index);
        ProfileStructure oldStructure = this.children[index];
        this.children[index] = structure;
        try {
            this.vetoableChangeSupport.fireVetoableChange("structure", null, null);
        }
        catch (PropertyVetoException vetoException) {
            this.children[index] = oldStructure;
            throw new ProfileException(null, vetoException);
        }
        this.propertyChangeSupport.firePropertyChange("structure", null, null);
    }

    public int getChildren() {
        return this.children.length;
    }

    private void extendChildList(int index) {
        if (index >= this.children.length) {
            ProfileStructure[] newCopy = new ProfileStructure[index + 1];
            System.arraycopy(this.children, 0, newCopy, 0, this.children.length);
            this.children = newCopy;
        }
    }
}

