/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class BaseWriter {
    protected JsonObject object;

    public BaseWriter(JsonObject object) {
        this.object = object;
    }

    protected JsonObject ensureObject(String name) {
        JsonObject child = this.object.getAsJsonObject(name);
        if (child == null) {
            child = new JsonObject();
            this.object.add(name, (JsonElement)child);
        }
        return child;
    }

    protected JsonObject ensureArrayObject(String arrayName, String propertyName, String value) {
        JsonArray arr = this.forceArray(arrayName);
        for (JsonElement e : arr) {
            String s = e.getAsJsonObject().get(propertyName).getAsString();
            if (!value.equals(s)) continue;
            return e.getAsJsonObject();
        }
        JsonObject e = new JsonObject();
        arr.add((JsonElement)e);
        e.addProperty(propertyName, value);
        return e;
    }

    protected JsonArray forceArray(String arrayName) {
        JsonArray arr = this.object.getAsJsonArray(arrayName);
        if (arr == null) {
            arr = new JsonArray();
            this.object.add(arrayName, (JsonElement)arr);
        }
        return arr;
    }

    protected JsonObject forceArrayObject(String arrayName) {
        JsonArray arr = this.object.getAsJsonArray(arrayName);
        if (arr == null) {
            arr = new JsonArray();
            this.object.add(arrayName, (JsonElement)arr);
        }
        JsonObject obj = new JsonObject();
        arr.add((JsonElement)obj);
        return obj;
    }

    protected JsonObject ensureMapObject(String mapName, String value) {
        JsonObject map = this.object.getAsJsonObject(mapName);
        if (map == null) {
            map = new JsonObject();
            this.object.add(mapName, (JsonElement)map);
        }
        if (map.has(value)) {
            return map.getAsJsonObject(value);
        }
        JsonObject e = new JsonObject();
        map.add(value, (JsonElement)e);
        return e;
    }

    protected JsonObject ensureMapObject(String value) {
        if (this.object.has(value)) {
            return this.object.getAsJsonObject(value);
        }
        JsonObject e = new JsonObject();
        this.object.add(value, (JsonElement)e);
        return e;
    }
}

