/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3EntityRisk {
    AGG,
    BIO,
    COR,
    ESC,
    IFL,
    EXP,
    INF,
    BHZ,
    INJ,
    POI,
    RAD,
    NULL;


    public static V3EntityRisk fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AGG".equals(codeString)) {
            return AGG;
        }
        if ("BIO".equals(codeString)) {
            return BIO;
        }
        if ("COR".equals(codeString)) {
            return COR;
        }
        if ("ESC".equals(codeString)) {
            return ESC;
        }
        if ("IFL".equals(codeString)) {
            return IFL;
        }
        if ("EXP".equals(codeString)) {
            return EXP;
        }
        if ("INF".equals(codeString)) {
            return INF;
        }
        if ("BHZ".equals(codeString)) {
            return BHZ;
        }
        if ("INJ".equals(codeString)) {
            return INJ;
        }
        if ("POI".equals(codeString)) {
            return POI;
        }
        if ("RAD".equals(codeString)) {
            return RAD;
        }
        throw new FHIRException("Unknown V3EntityRisk code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AGG: {
                return "AGG";
            }
            case BIO: {
                return "BIO";
            }
            case COR: {
                return "COR";
            }
            case ESC: {
                return "ESC";
            }
            case IFL: {
                return "IFL";
            }
            case EXP: {
                return "EXP";
            }
            case INF: {
                return "INF";
            }
            case BHZ: {
                return "BHZ";
            }
            case INJ: {
                return "INJ";
            }
            case POI: {
                return "POI";
            }
            case RAD: {
                return "RAD";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-EntityRisk";
    }

    public String getDefinition() {
        switch (this) {
            case AGG: {
                return "A danger that can be associated with certain living subjects, including humans.";
            }
            case BIO: {
                return "The dangers associated with normal biological materials. I.e. potential risk of unknown infections.  Routine biological materials from living subjects.";
            }
            case COR: {
                return "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact.";
            }
            case ESC: {
                return "The entity is at risk for escaping from containment or control.";
            }
            case IFL: {
                return "Material is highly inflammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat.";
            }
            case EXP: {
                return "Material is an explosive mixture.  Keep away from fire, sparks, and heat.";
            }
            case INF: {
                return "Material known to be infectious with human pathogenic microorganisms.  Those who handle this material must take precautions for their protection.";
            }
            case BHZ: {
                return "Material contains microorganisms that is an environmental hazard.  Must be handled with special care.";
            }
            case INJ: {
                return "Material is solid and sharp (e.g., cannulas).  Dispose in hard container.";
            }
            case POI: {
                return "Material is poisonous to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts.";
            }
            case RAD: {
                return "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AGG: {
                return "aggressive";
            }
            case BIO: {
                return "Biological";
            }
            case COR: {
                return "Corrosive";
            }
            case ESC: {
                return "Escape Risk";
            }
            case IFL: {
                return "inflammable";
            }
            case EXP: {
                return "explosive";
            }
            case INF: {
                return "infectious";
            }
            case BHZ: {
                return "biohazard";
            }
            case INJ: {
                return "injury hazard";
            }
            case POI: {
                return "poison";
            }
            case RAD: {
                return "radioactive";
            }
        }
        return "?";
    }
}

