/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3EmployeeJobClass {
    FT,
    PT,
    NULL;


    public static V3EmployeeJobClass fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("FT".equals(codeString)) {
            return FT;
        }
        if ("PT".equals(codeString)) {
            return PT;
        }
        throw new FHIRException("Unknown V3EmployeeJobClass code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FT: {
                return "FT";
            }
            case PT: {
                return "PT";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-EmployeeJobClass";
    }

    public String getDefinition() {
        switch (this) {
            case FT: {
                return "Employment in which the employee is expected to work at least a standard work week (defined by the US Bureau of Labor Statistics as 35-44 hours per week)";
            }
            case PT: {
                return "Employment in which the employee is expected to work less than a standard work week (defined by the US Bureau of Labor Statistics as 35-44 hours per week)";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FT: {
                return "full-time";
            }
            case PT: {
                return "part-time";
            }
        }
        return "?";
    }
}

