/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TransactionMode {
    NOTSUPPORTED,
    BATCH,
    TRANSACTION,
    BOTH,
    NULL;


    public static TransactionMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-supported".equals(codeString)) {
            return NOTSUPPORTED;
        }
        if ("batch".equals(codeString)) {
            return BATCH;
        }
        if ("transaction".equals(codeString)) {
            return TRANSACTION;
        }
        if ("both".equals(codeString)) {
            return BOTH;
        }
        throw new FHIRException("Unknown TransactionMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTSUPPORTED: {
                return "not-supported";
            }
            case BATCH: {
                return "batch";
            }
            case TRANSACTION: {
                return "transaction";
            }
            case BOTH: {
                return "both";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/transaction-mode";
    }

    public String getDefinition() {
        switch (this) {
            case NOTSUPPORTED: {
                return "Neither batch or transaction is supported.";
            }
            case BATCH: {
                return "Batches are  supported.";
            }
            case TRANSACTION: {
                return "Transactions are supported.";
            }
            case BOTH: {
                return "Both batches and transactions are supported.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTSUPPORTED: {
                return "None";
            }
            case BATCH: {
                return "Batches supported";
            }
            case TRANSACTION: {
                return "Transactions Supported";
            }
            case BOTH: {
                return "Batches & Transactions";
            }
        }
        return "?";
    }
}

