/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum StrandType {
    WATSON,
    CRICK,
    NULL;


    public static StrandType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("watson".equals(codeString)) {
            return WATSON;
        }
        if ("crick".equals(codeString)) {
            return CRICK;
        }
        throw new FHIRException("Unknown StrandType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case WATSON: {
                return "watson";
            }
            case CRICK: {
                return "crick";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/strand-type";
    }

    public String getDefinition() {
        switch (this) {
            case WATSON: {
                return "Watson strand of reference sequence.";
            }
            case CRICK: {
                return "Crick strand of reference sequence.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case WATSON: {
                return "Watson strand of referenceSeq";
            }
            case CRICK: {
                return "Crick strand of referenceSeq";
            }
        }
        return "?";
    }
}

