/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SortDirection {
    ASCENDING,
    DESCENDING,
    NULL;


    public static SortDirection fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ascending".equals(codeString)) {
            return ASCENDING;
        }
        if ("descending".equals(codeString)) {
            return DESCENDING;
        }
        throw new FHIRException("Unknown SortDirection code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ASCENDING: {
                return "ascending";
            }
            case DESCENDING: {
                return "descending";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/sort-direction";
    }

    public String getDefinition() {
        switch (this) {
            case ASCENDING: {
                return "Sort by the value ascending, so that lower values appear first.";
            }
            case DESCENDING: {
                return "Sort by the value descending, so that lower values appear last.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ASCENDING: {
                return "Ascending";
            }
            case DESCENDING: {
                return "Descending";
            }
        }
        return "?";
    }
}

