/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.QuantityComparator;

public class QuantityComparatorEnumFactory
implements EnumFactory<QuantityComparator> {
    @Override
    public QuantityComparator fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("<".equals(codeString)) {
            return QuantityComparator.LESS_THAN;
        }
        if ("<=".equals(codeString)) {
            return QuantityComparator.LESS_OR_EQUAL;
        }
        if (">=".equals(codeString)) {
            return QuantityComparator.GREATER_OR_EQUAL;
        }
        if (">".equals(codeString)) {
            return QuantityComparator.GREATER_THAN;
        }
        throw new IllegalArgumentException("Unknown QuantityComparator code '" + codeString + "'");
    }

    @Override
    public String toCode(QuantityComparator code) {
        if (code == QuantityComparator.LESS_THAN) {
            return "<";
        }
        if (code == QuantityComparator.LESS_OR_EQUAL) {
            return "<=";
        }
        if (code == QuantityComparator.GREATER_OR_EQUAL) {
            return ">=";
        }
        if (code == QuantityComparator.GREATER_THAN) {
            return ">";
        }
        return "?";
    }

    @Override
    public String toSystem(QuantityComparator code) {
        return code.getSystem();
    }
}

