/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum KnowledgeResourceTypes {
    ACTIVITYDEFINITION,
    CODESYSTEM,
    CONCEPTMAP,
    LIBRARY,
    MEASURE,
    PLANDEFINITION,
    STRUCTUREDEFINITION,
    STRUCTUREMAP,
    VALUESET,
    NULL;


    public static KnowledgeResourceTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ActivityDefinition".equals(codeString)) {
            return ACTIVITYDEFINITION;
        }
        if ("CodeSystem".equals(codeString)) {
            return CODESYSTEM;
        }
        if ("ConceptMap".equals(codeString)) {
            return CONCEPTMAP;
        }
        if ("Library".equals(codeString)) {
            return LIBRARY;
        }
        if ("Measure".equals(codeString)) {
            return MEASURE;
        }
        if ("PlanDefinition".equals(codeString)) {
            return PLANDEFINITION;
        }
        if ("StructureDefinition".equals(codeString)) {
            return STRUCTUREDEFINITION;
        }
        if ("StructureMap".equals(codeString)) {
            return STRUCTUREMAP;
        }
        if ("ValueSet".equals(codeString)) {
            return VALUESET;
        }
        throw new FHIRException("Unknown KnowledgeResourceTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case CODESYSTEM: {
                return "CodeSystem";
            }
            case CONCEPTMAP: {
                return "ConceptMap";
            }
            case LIBRARY: {
                return "Library";
            }
            case MEASURE: {
                return "Measure";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case STRUCTUREDEFINITION: {
                return "StructureDefinition";
            }
            case STRUCTUREMAP: {
                return "StructureMap";
            }
            case VALUESET: {
                return "ValueSet";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/knowledge-resource-types";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "The definition of a specific activity to be taken, independent of any particular patient or context.";
            }
            case CODESYSTEM: {
                return "A set of codes drawn from one or more code systems.";
            }
            case CONCEPTMAP: {
                return "A map from one set of concepts to one or more other concepts.";
            }
            case LIBRARY: {
                return "Represents a library of quality improvement components.";
            }
            case MEASURE: {
                return "A quality measure definition.";
            }
            case PLANDEFINITION: {
                return "The definition of a plan for a series of actions, independent of any specific patient or context.";
            }
            case STRUCTUREDEFINITION: {
                return "Structural Definition.";
            }
            case STRUCTUREMAP: {
                return "A Map of relationships between 2 structures that can be used to transform data.";
            }
            case VALUESET: {
                return "A set of codes drawn from one or more code systems.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case CODESYSTEM: {
                return "CodeSystem";
            }
            case CONCEPTMAP: {
                return "ConceptMap";
            }
            case LIBRARY: {
                return "Library";
            }
            case MEASURE: {
                return "Measure";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case STRUCTUREDEFINITION: {
                return "StructureDefinition";
            }
            case STRUCTUREMAP: {
                return "StructureMap";
            }
            case VALUESET: {
                return "ValueSet";
            }
        }
        return "?";
    }
}

