/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum FeedingDevice {
    STANDARDNIPPLE,
    PREEMIENIPPLE,
    ORTHONIPPLE,
    SLOFLONIPPLE,
    MIDFLONIPPLE,
    BIGCUTNIPPLE,
    HABERMANBOTTLE,
    SIPPYVALVE,
    SIPPYNOVALVE,
    PROVALECUP,
    GLASSLID,
    HANDHOLDCUP,
    RUBBERMAT,
    STRAW,
    NOSECUP,
    SCOOPPLATE,
    UTENSILHOLDER,
    FOAMHANDLE,
    ANGLEDUTENSIL,
    SPOUTCUP,
    AUTOFEEDINGDEVICE,
    ROCKERKNIFE,
    NULL;


    public static FeedingDevice fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("standard-nipple".equals(codeString)) {
            return STANDARDNIPPLE;
        }
        if ("preemie-nipple".equals(codeString)) {
            return PREEMIENIPPLE;
        }
        if ("ortho-nipple".equals(codeString)) {
            return ORTHONIPPLE;
        }
        if ("sloflo-nipple".equals(codeString)) {
            return SLOFLONIPPLE;
        }
        if ("midflo-nipple".equals(codeString)) {
            return MIDFLONIPPLE;
        }
        if ("bigcut-nipple".equals(codeString)) {
            return BIGCUTNIPPLE;
        }
        if ("haberman-bottle".equals(codeString)) {
            return HABERMANBOTTLE;
        }
        if ("sippy-valve".equals(codeString)) {
            return SIPPYVALVE;
        }
        if ("sippy-no-valve".equals(codeString)) {
            return SIPPYNOVALVE;
        }
        if ("provale-cup".equals(codeString)) {
            return PROVALECUP;
        }
        if ("glass-lid".equals(codeString)) {
            return GLASSLID;
        }
        if ("handhold-cup".equals(codeString)) {
            return HANDHOLDCUP;
        }
        if ("rubber-mat".equals(codeString)) {
            return RUBBERMAT;
        }
        if ("straw".equals(codeString)) {
            return STRAW;
        }
        if ("nose-cup".equals(codeString)) {
            return NOSECUP;
        }
        if ("scoop-plate".equals(codeString)) {
            return SCOOPPLATE;
        }
        if ("utensil-holder".equals(codeString)) {
            return UTENSILHOLDER;
        }
        if ("foam-handle".equals(codeString)) {
            return FOAMHANDLE;
        }
        if ("angled-utensil".equals(codeString)) {
            return ANGLEDUTENSIL;
        }
        if ("spout-cup".equals(codeString)) {
            return SPOUTCUP;
        }
        if ("autofeeding-device".equals(codeString)) {
            return AUTOFEEDINGDEVICE;
        }
        if ("rocker-knife".equals(codeString)) {
            return ROCKERKNIFE;
        }
        throw new FHIRException("Unknown FeedingDevice code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STANDARDNIPPLE: {
                return "standard-nipple";
            }
            case PREEMIENIPPLE: {
                return "preemie-nipple";
            }
            case ORTHONIPPLE: {
                return "ortho-nipple";
            }
            case SLOFLONIPPLE: {
                return "sloflo-nipple";
            }
            case MIDFLONIPPLE: {
                return "midflo-nipple";
            }
            case BIGCUTNIPPLE: {
                return "bigcut-nipple";
            }
            case HABERMANBOTTLE: {
                return "haberman-bottle";
            }
            case SIPPYVALVE: {
                return "sippy-valve";
            }
            case SIPPYNOVALVE: {
                return "sippy-no-valve";
            }
            case PROVALECUP: {
                return "provale-cup";
            }
            case GLASSLID: {
                return "glass-lid";
            }
            case HANDHOLDCUP: {
                return "handhold-cup";
            }
            case RUBBERMAT: {
                return "rubber-mat";
            }
            case STRAW: {
                return "straw";
            }
            case NOSECUP: {
                return "nose-cup";
            }
            case SCOOPPLATE: {
                return "scoop-plate";
            }
            case UTENSILHOLDER: {
                return "utensil-holder";
            }
            case FOAMHANDLE: {
                return "foam-handle";
            }
            case ANGLEDUTENSIL: {
                return "angled-utensil";
            }
            case SPOUTCUP: {
                return "spout-cup";
            }
            case AUTOFEEDINGDEVICE: {
                return "autofeeding-device";
            }
            case ROCKERKNIFE: {
                return "rocker-knife";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/feeding-device";
    }

    public String getDefinition() {
        switch (this) {
            case STANDARDNIPPLE: {
                return "Standard nipple definition:";
            }
            case PREEMIENIPPLE: {
                return "Preemie nipple definition:";
            }
            case ORTHONIPPLE: {
                return "Orthodontic nipple definition:";
            }
            case SLOFLONIPPLE: {
                return "Slow flow nipple definition:";
            }
            case MIDFLONIPPLE: {
                return "Middle flow nipple definition:";
            }
            case BIGCUTNIPPLE: {
                return "Enlarged, cross-cut nipple definition:";
            }
            case HABERMANBOTTLE: {
                return "Haberman bottle definition:";
            }
            case SIPPYVALVE: {
                return "Sippy cup with valve definition:";
            }
            case SIPPYNOVALVE: {
                return "Sippy cup without valve definition:";
            }
            case PROVALECUP: {
                return "Provale Cup definition:";
            }
            case GLASSLID: {
                return "Glass with lid/sippy cup definition:";
            }
            case HANDHOLDCUP: {
                return "Double handhold on glass/cup definition:";
            }
            case RUBBERMAT: {
                return "Rubber matting under tray definition:";
            }
            case STRAW: {
                return "Straw definition:";
            }
            case NOSECUP: {
                return "Nose cup definition:";
            }
            case SCOOPPLATE: {
                return "Scoop plate definition:";
            }
            case UTENSILHOLDER: {
                return "Hand wrap utensil holder definition:";
            }
            case FOAMHANDLE: {
                return "Foam handle utensils definition:";
            }
            case ANGLEDUTENSIL: {
                return "Angled utensils definition:";
            }
            case SPOUTCUP: {
                return "Spout cup definition:";
            }
            case AUTOFEEDINGDEVICE: {
                return "Automated feeding devices definition:";
            }
            case ROCKERKNIFE: {
                return "Rocker knife definition:";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STANDARDNIPPLE: {
                return "Standard nipple";
            }
            case PREEMIENIPPLE: {
                return "Preemie nipple";
            }
            case ORTHONIPPLE: {
                return "Orthodontic nipple";
            }
            case SLOFLONIPPLE: {
                return "Slow flow nipple";
            }
            case MIDFLONIPPLE: {
                return "Middle flow nipple";
            }
            case BIGCUTNIPPLE: {
                return "Enlarged, cross-cut nipple";
            }
            case HABERMANBOTTLE: {
                return "Haberman bottle";
            }
            case SIPPYVALVE: {
                return "Sippy cup with valve";
            }
            case SIPPYNOVALVE: {
                return "Sippy cup without valve";
            }
            case PROVALECUP: {
                return "Provale Cup";
            }
            case GLASSLID: {
                return "Glass with lid/sippy cup";
            }
            case HANDHOLDCUP: {
                return "Double handhold on glass/cup";
            }
            case RUBBERMAT: {
                return "Rubber matting under tray";
            }
            case STRAW: {
                return "Straw";
            }
            case NOSECUP: {
                return "Nose cup";
            }
            case SCOOPPLATE: {
                return "Scoop plate";
            }
            case UTENSILHOLDER: {
                return "Hand wrap utensil holder";
            }
            case FOAMHANDLE: {
                return "Foam handle utensils";
            }
            case ANGLEDUTENSIL: {
                return "Angled utensils";
            }
            case SPOUTCUP: {
                return "Spout cup";
            }
            case AUTOFEEDINGDEVICE: {
                return "Automated feeding devices";
            }
            case ROCKERKNIFE: {
                return "Rocker knife";
            }
        }
        return "?";
    }
}

