/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EventCapabilityMode {
    SENDER,
    RECEIVER,
    NULL;


    public static EventCapabilityMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sender".equals(codeString)) {
            return SENDER;
        }
        if ("receiver".equals(codeString)) {
            return RECEIVER;
        }
        throw new FHIRException("Unknown EventCapabilityMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SENDER: {
                return "sender";
            }
            case RECEIVER: {
                return "receiver";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/event-capability-mode";
    }

    public String getDefinition() {
        switch (this) {
            case SENDER: {
                return "The application sends requests and receives responses.";
            }
            case RECEIVER: {
                return "The application receives requests and sends responses.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SENDER: {
                return "Sender";
            }
            case RECEIVER: {
                return "Receiver";
            }
        }
        return "?";
    }
}

