/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterParticipantType {
    TRANSLATOR,
    EMERGENCY,
    NULL;


    public static EncounterParticipantType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("translator".equals(codeString)) {
            return TRANSLATOR;
        }
        if ("emergency".equals(codeString)) {
            return EMERGENCY;
        }
        throw new FHIRException("Unknown EncounterParticipantType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TRANSLATOR: {
                return "translator";
            }
            case EMERGENCY: {
                return "emergency";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/participant-type";
    }

    public String getDefinition() {
        switch (this) {
            case TRANSLATOR: {
                return "A translator who is facilitating communication with the patient during the encounter.";
            }
            case EMERGENCY: {
                return "A person to be contacted in case of an emergency during the encounter.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TRANSLATOR: {
                return "Translator";
            }
            case EMERGENCY: {
                return "Emergency";
            }
        }
        return "?";
    }
}

