/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CompositeMeasureScoring {
    OPPORTUNITY,
    ALLORNOTHING,
    LINEAR,
    WEIGHTED,
    NULL;


    public static CompositeMeasureScoring fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("opportunity".equals(codeString)) {
            return OPPORTUNITY;
        }
        if ("all-or-nothing".equals(codeString)) {
            return ALLORNOTHING;
        }
        if ("linear".equals(codeString)) {
            return LINEAR;
        }
        if ("weighted".equals(codeString)) {
            return WEIGHTED;
        }
        throw new FHIRException("Unknown CompositeMeasureScoring code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OPPORTUNITY: {
                return "opportunity";
            }
            case ALLORNOTHING: {
                return "all-or-nothing";
            }
            case LINEAR: {
                return "linear";
            }
            case WEIGHTED: {
                return "weighted";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/composite-measure-scoring";
    }

    public String getDefinition() {
        switch (this) {
            case OPPORTUNITY: {
                return "Opportunity scoring combines the scores from component measures by combining the numerators and denominators for each component.";
            }
            case ALLORNOTHING: {
                return "All-or-nothing scoring includes an individual in the numerator of the composite measure if they are in the numerators of all of the component measures in which they are in the denominator.";
            }
            case LINEAR: {
                return "Linear scoring gives an individual a score based on the number of numerators in which they appear.";
            }
            case WEIGHTED: {
                return "Weighted scoring gives an individual a score based on a weighted factor for each component numerator in which they appear.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OPPORTUNITY: {
                return "Opportunity";
            }
            case ALLORNOTHING: {
                return "All-or-nothing";
            }
            case LINEAR: {
                return "Linear";
            }
            case WEIGHTED: {
                return "Weighted";
            }
        }
        return "?";
    }
}

