/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ClinicalUseIssueType;

public class ClinicalUseIssueTypeEnumFactory
implements EnumFactory<ClinicalUseIssueType> {
    @Override
    public ClinicalUseIssueType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("indication".equals(codeString)) {
            return ClinicalUseIssueType.INDICATION;
        }
        if ("contraindication".equals(codeString)) {
            return ClinicalUseIssueType.CONTRAINDICATION;
        }
        if ("interaction".equals(codeString)) {
            return ClinicalUseIssueType.INTERACTION;
        }
        if ("undesirable-effect".equals(codeString)) {
            return ClinicalUseIssueType.UNDESIRABLEEFFECT;
        }
        if ("other".equals(codeString)) {
            return ClinicalUseIssueType.OTHER;
        }
        throw new IllegalArgumentException("Unknown ClinicalUseIssueType code '" + codeString + "'");
    }

    @Override
    public String toCode(ClinicalUseIssueType code) {
        if (code == ClinicalUseIssueType.INDICATION) {
            return "indication";
        }
        if (code == ClinicalUseIssueType.CONTRAINDICATION) {
            return "contraindication";
        }
        if (code == ClinicalUseIssueType.INTERACTION) {
            return "interaction";
        }
        if (code == ClinicalUseIssueType.UNDESIRABLEEFFECT) {
            return "undesirable-effect";
        }
        if (code == ClinicalUseIssueType.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(ClinicalUseIssueType code) {
        return code.getSystem();
    }
}

