/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogentryType {
    ACTIVITYDEFINITION,
    PLANDEFINITION,
    SPECIMENDEFINITION,
    OBSERVATIONDEFINITION,
    DEVICEDEFINITION,
    ORGANIZATION,
    PRACTITIONER,
    PRACTITIONERROLE,
    HEALTHCARESERVICE,
    MEDICATIONKNOWLEDGE,
    MEDICATION,
    SUBSTANCE,
    LOCATION,
    NULL;


    public static CatalogentryType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ActivityDefinition".equals(codeString)) {
            return ACTIVITYDEFINITION;
        }
        if ("PlanDefinition".equals(codeString)) {
            return PLANDEFINITION;
        }
        if ("SpecimenDefinition".equals(codeString)) {
            return SPECIMENDEFINITION;
        }
        if ("ObservationDefinition".equals(codeString)) {
            return OBSERVATIONDEFINITION;
        }
        if ("DeviceDefinition".equals(codeString)) {
            return DEVICEDEFINITION;
        }
        if ("Organization".equals(codeString)) {
            return ORGANIZATION;
        }
        if ("Practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("PractitionerRole".equals(codeString)) {
            return PRACTITIONERROLE;
        }
        if ("HealthcareService".equals(codeString)) {
            return HEALTHCARESERVICE;
        }
        if ("MedicationKnowledge".equals(codeString)) {
            return MEDICATIONKNOWLEDGE;
        }
        if ("Medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("Substance".equals(codeString)) {
            return SUBSTANCE;
        }
        if ("Location".equals(codeString)) {
            return LOCATION;
        }
        throw new FHIRException("Unknown CatalogentryType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case SPECIMENDEFINITION: {
                return "SpecimenDefinition";
            }
            case OBSERVATIONDEFINITION: {
                return "ObservationDefinition";
            }
            case DEVICEDEFINITION: {
                return "DeviceDefinition";
            }
            case ORGANIZATION: {
                return "Organization";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case PRACTITIONERROLE: {
                return "PractitionerRole";
            }
            case HEALTHCARESERVICE: {
                return "HealthcareService";
            }
            case MEDICATIONKNOWLEDGE: {
                return "MedicationKnowledge";
            }
            case MEDICATION: {
                return "Medication";
            }
            case SUBSTANCE: {
                return "Substance";
            }
            case LOCATION: {
                return "Location";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalogentry-type";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "";
            }
            case PLANDEFINITION: {
                return "";
            }
            case SPECIMENDEFINITION: {
                return "";
            }
            case OBSERVATIONDEFINITION: {
                return "";
            }
            case DEVICEDEFINITION: {
                return "";
            }
            case ORGANIZATION: {
                return "";
            }
            case PRACTITIONER: {
                return "";
            }
            case PRACTITIONERROLE: {
                return "";
            }
            case HEALTHCARESERVICE: {
                return "";
            }
            case MEDICATIONKNOWLEDGE: {
                return "";
            }
            case MEDICATION: {
                return "";
            }
            case SUBSTANCE: {
                return "";
            }
            case LOCATION: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVITYDEFINITION: {
                return "ActivityDefinition";
            }
            case PLANDEFINITION: {
                return "PlanDefinition";
            }
            case SPECIMENDEFINITION: {
                return "SpecimenDefinition";
            }
            case OBSERVATIONDEFINITION: {
                return "ObservationDefinition";
            }
            case DEVICEDEFINITION: {
                return "DeviceDefinition";
            }
            case ORGANIZATION: {
                return "Organization";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case PRACTITIONERROLE: {
                return "PractitionerRole";
            }
            case HEALTHCARESERVICE: {
                return "HealthcareService";
            }
            case MEDICATIONKNOWLEDGE: {
                return "MedicationKnowledge";
            }
            case MEDICATION: {
                return "Medication";
            }
            case SUBSTANCE: {
                return "Substance";
            }
            case LOCATION: {
                return "Location";
            }
        }
        return "?";
    }
}

