/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdjudicationError {
    A001,
    A002,
    NULL;


    public static AdjudicationError fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("a001".equals(codeString)) {
            return A001;
        }
        if ("a002".equals(codeString)) {
            return A002;
        }
        throw new FHIRException("Unknown AdjudicationError code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A001: {
                return "a001";
            }
            case A002: {
                return "a002";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adjudication-error";
    }

    public String getDefinition() {
        switch (this) {
            case A001: {
                return "Missing Identifier";
            }
            case A002: {
                return "Missing Creation Date";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A001: {
                return "Missing Identifier";
            }
            case A002: {
                return "Missing Creation Date";
            }
        }
        return "?";
    }
}

