/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ProdCharacteristic")
public class ProdCharacteristic
extends BackboneType
implements ICompositeType {
    @Child(name="height", type={Quantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the height can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the height can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity height;
    @Child(name="width", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the width can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the width can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity width;
    @Child(name="depth", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the depth can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the depth can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity depth;
    @Child(name="weight", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the weight can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the weight can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity weight;
    @Child(name="nominalVolume", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the nominal volume can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the nominal volume can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity nominalVolume;
    @Child(name="externalDiameter", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the external diameter can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="Where applicable, the external diameter can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected Quantity externalDiameter;
    @Child(name="shape", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the shape can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used", formalDefinition="Where applicable, the shape can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.")
    protected StringType shape;
    @Child(name="color", type={StringType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the color can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used", formalDefinition="Where applicable, the color can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.")
    protected List<StringType> color;
    @Child(name="imprint", type={StringType.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the imprint can be specified as text", formalDefinition="Where applicable, the imprint can be specified as text.")
    protected List<StringType> imprint;
    @Child(name="image", type={Attachment.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the image can be provided The format of the image attachment shall be specified by regional implementations", formalDefinition="Where applicable, the image can be provided The format of the image attachment shall be specified by regional implementations.")
    protected List<Attachment> image;
    @Child(name="scoring", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where applicable, the scoring can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used", formalDefinition="Where applicable, the scoring can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.")
    protected CodeableConcept scoring;
    private static final long serialVersionUID = 1521671432L;

    public Quantity getHeight() {
        if (this.height == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.height");
            }
            if (Configuration.doAutoCreate()) {
                this.height = new Quantity();
            }
        }
        return this.height;
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public ProdCharacteristic setHeight(Quantity value) {
        this.height = value;
        return this;
    }

    public Quantity getWidth() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new Quantity();
            }
        }
        return this.width;
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public ProdCharacteristic setWidth(Quantity value) {
        this.width = value;
        return this;
    }

    public Quantity getDepth() {
        if (this.depth == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.depth");
            }
            if (Configuration.doAutoCreate()) {
                this.depth = new Quantity();
            }
        }
        return this.depth;
    }

    public boolean hasDepth() {
        return this.depth != null && !this.depth.isEmpty();
    }

    public ProdCharacteristic setDepth(Quantity value) {
        this.depth = value;
        return this;
    }

    public Quantity getWeight() {
        if (this.weight == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.weight");
            }
            if (Configuration.doAutoCreate()) {
                this.weight = new Quantity();
            }
        }
        return this.weight;
    }

    public boolean hasWeight() {
        return this.weight != null && !this.weight.isEmpty();
    }

    public ProdCharacteristic setWeight(Quantity value) {
        this.weight = value;
        return this;
    }

    public Quantity getNominalVolume() {
        if (this.nominalVolume == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.nominalVolume");
            }
            if (Configuration.doAutoCreate()) {
                this.nominalVolume = new Quantity();
            }
        }
        return this.nominalVolume;
    }

    public boolean hasNominalVolume() {
        return this.nominalVolume != null && !this.nominalVolume.isEmpty();
    }

    public ProdCharacteristic setNominalVolume(Quantity value) {
        this.nominalVolume = value;
        return this;
    }

    public Quantity getExternalDiameter() {
        if (this.externalDiameter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.externalDiameter");
            }
            if (Configuration.doAutoCreate()) {
                this.externalDiameter = new Quantity();
            }
        }
        return this.externalDiameter;
    }

    public boolean hasExternalDiameter() {
        return this.externalDiameter != null && !this.externalDiameter.isEmpty();
    }

    public ProdCharacteristic setExternalDiameter(Quantity value) {
        this.externalDiameter = value;
        return this;
    }

    public StringType getShapeElement() {
        if (this.shape == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.shape");
            }
            if (Configuration.doAutoCreate()) {
                this.shape = new StringType();
            }
        }
        return this.shape;
    }

    public boolean hasShapeElement() {
        return this.shape != null && !this.shape.isEmpty();
    }

    public boolean hasShape() {
        return this.shape != null && !this.shape.isEmpty();
    }

    public ProdCharacteristic setShapeElement(StringType value) {
        this.shape = value;
        return this;
    }

    public String getShape() {
        return this.shape == null ? null : (String)this.shape.getValue();
    }

    public ProdCharacteristic setShape(String value) {
        if (Utilities.noString((String)value)) {
            this.shape = null;
        } else {
            if (this.shape == null) {
                this.shape = new StringType();
            }
            this.shape.setValue(value);
        }
        return this;
    }

    public List<StringType> getColor() {
        if (this.color == null) {
            this.color = new ArrayList<StringType>();
        }
        return this.color;
    }

    public ProdCharacteristic setColor(List<StringType> theColor) {
        this.color = theColor;
        return this;
    }

    public boolean hasColor() {
        if (this.color == null) {
            return false;
        }
        for (StringType item : this.color) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addColorElement() {
        StringType t = new StringType();
        if (this.color == null) {
            this.color = new ArrayList<StringType>();
        }
        this.color.add(t);
        return t;
    }

    public ProdCharacteristic addColor(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.color == null) {
            this.color = new ArrayList<StringType>();
        }
        this.color.add(t);
        return this;
    }

    public boolean hasColor(String value) {
        if (this.color == null) {
            return false;
        }
        for (StringType v : this.color) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getImprint() {
        if (this.imprint == null) {
            this.imprint = new ArrayList<StringType>();
        }
        return this.imprint;
    }

    public ProdCharacteristic setImprint(List<StringType> theImprint) {
        this.imprint = theImprint;
        return this;
    }

    public boolean hasImprint() {
        if (this.imprint == null) {
            return false;
        }
        for (StringType item : this.imprint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addImprintElement() {
        StringType t = new StringType();
        if (this.imprint == null) {
            this.imprint = new ArrayList<StringType>();
        }
        this.imprint.add(t);
        return t;
    }

    public ProdCharacteristic addImprint(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.imprint == null) {
            this.imprint = new ArrayList<StringType>();
        }
        this.imprint.add(t);
        return this;
    }

    public boolean hasImprint(String value) {
        if (this.imprint == null) {
            return false;
        }
        for (StringType v : this.imprint) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Attachment> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        return this.image;
    }

    public ProdCharacteristic setImage(List<Attachment> theImage) {
        this.image = theImage;
        return this;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (Attachment item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addImage() {
        Attachment t = new Attachment();
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return t;
    }

    public ProdCharacteristic addImage(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return this;
    }

    public Attachment getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            this.addImage();
        }
        return this.getImage().get(0);
    }

    public CodeableConcept getScoring() {
        if (this.scoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProdCharacteristic.scoring");
            }
            if (Configuration.doAutoCreate()) {
                this.scoring = new CodeableConcept();
            }
        }
        return this.scoring;
    }

    public boolean hasScoring() {
        return this.scoring != null && !this.scoring.isEmpty();
    }

    public ProdCharacteristic setScoring(CodeableConcept value) {
        this.scoring = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("height", "Quantity", "Where applicable, the height can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.height));
        children.add(new Property("width", "Quantity", "Where applicable, the width can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.width));
        children.add(new Property("depth", "Quantity", "Where applicable, the depth can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.depth));
        children.add(new Property("weight", "Quantity", "Where applicable, the weight can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.weight));
        children.add(new Property("nominalVolume", "Quantity", "Where applicable, the nominal volume can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.nominalVolume));
        children.add(new Property("externalDiameter", "Quantity", "Where applicable, the external diameter can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.externalDiameter));
        children.add(new Property("shape", "string", "Where applicable, the shape can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, 1, this.shape));
        children.add(new Property("color", "string", "Where applicable, the color can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, Integer.MAX_VALUE, this.color));
        children.add(new Property("imprint", "string", "Where applicable, the imprint can be specified as text.", 0, Integer.MAX_VALUE, this.imprint));
        children.add(new Property("image", "Attachment", "Where applicable, the image can be provided The format of the image attachment shall be specified by regional implementations.", 0, Integer.MAX_VALUE, this.image));
        children.add(new Property("scoring", "CodeableConcept", "Where applicable, the scoring can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, 1, this.scoring));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1221029593: {
                return new Property("height", "Quantity", "Where applicable, the height can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.height);
            }
            case 113126854: {
                return new Property("width", "Quantity", "Where applicable, the width can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.width);
            }
            case 95472323: {
                return new Property("depth", "Quantity", "Where applicable, the depth can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.depth);
            }
            case -791592328: {
                return new Property("weight", "Quantity", "Where applicable, the weight can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.weight);
            }
            case 1706919702: {
                return new Property("nominalVolume", "Quantity", "Where applicable, the nominal volume can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.nominalVolume);
            }
            case 161374584: {
                return new Property("externalDiameter", "Quantity", "Where applicable, the external diameter can be specified using a numerical value and its unit of measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.externalDiameter);
            }
            case 109399969: {
                return new Property("shape", "string", "Where applicable, the shape can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, 1, this.shape);
            }
            case 94842723: {
                return new Property("color", "string", "Where applicable, the color can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, Integer.MAX_VALUE, this.color);
            }
            case 1926118409: {
                return new Property("imprint", "string", "Where applicable, the imprint can be specified as text.", 0, Integer.MAX_VALUE, this.imprint);
            }
            case 100313435: {
                return new Property("image", "Attachment", "Where applicable, the image can be provided The format of the image attachment shall be specified by regional implementations.", 0, Integer.MAX_VALUE, this.image);
            }
            case 1924005583: {
                return new Property("scoring", "CodeableConcept", "Where applicable, the scoring can be specified An appropriate controlled vocabulary shall be used The term and the term identifier shall be used.", 0, 1, this.scoring);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1221029593: {
                Base[] baseArray;
                if (this.height == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.height;
                }
                return baseArray;
            }
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.width;
                }
                return baseArray;
            }
            case 95472323: {
                Base[] baseArray;
                if (this.depth == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.depth;
                }
                return baseArray;
            }
            case -791592328: {
                Base[] baseArray;
                if (this.weight == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.weight;
                }
                return baseArray;
            }
            case 1706919702: {
                Base[] baseArray;
                if (this.nominalVolume == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.nominalVolume;
                }
                return baseArray;
            }
            case 161374584: {
                Base[] baseArray;
                if (this.externalDiameter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.externalDiameter;
                }
                return baseArray;
            }
            case 109399969: {
                Base[] baseArray;
                if (this.shape == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.shape;
                }
                return baseArray;
            }
            case 94842723: {
                return this.color == null ? new Base[]{} : this.color.toArray(new Base[this.color.size()]);
            }
            case 1926118409: {
                return this.imprint == null ? new Base[]{} : this.imprint.toArray(new Base[this.imprint.size()]);
            }
            case 100313435: {
                return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
            }
            case 1924005583: {
                Base[] baseArray;
                if (this.scoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.scoring;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1221029593: {
                this.height = this.castToQuantity(value);
                return value;
            }
            case 113126854: {
                this.width = this.castToQuantity(value);
                return value;
            }
            case 95472323: {
                this.depth = this.castToQuantity(value);
                return value;
            }
            case -791592328: {
                this.weight = this.castToQuantity(value);
                return value;
            }
            case 1706919702: {
                this.nominalVolume = this.castToQuantity(value);
                return value;
            }
            case 161374584: {
                this.externalDiameter = this.castToQuantity(value);
                return value;
            }
            case 109399969: {
                this.shape = this.castToString(value);
                return value;
            }
            case 94842723: {
                this.getColor().add(this.castToString(value));
                return value;
            }
            case 1926118409: {
                this.getImprint().add(this.castToString(value));
                return value;
            }
            case 100313435: {
                this.getImage().add(this.castToAttachment(value));
                return value;
            }
            case 1924005583: {
                this.scoring = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("height")) {
            this.height = this.castToQuantity(value);
        } else if (name.equals("width")) {
            this.width = this.castToQuantity(value);
        } else if (name.equals("depth")) {
            this.depth = this.castToQuantity(value);
        } else if (name.equals("weight")) {
            this.weight = this.castToQuantity(value);
        } else if (name.equals("nominalVolume")) {
            this.nominalVolume = this.castToQuantity(value);
        } else if (name.equals("externalDiameter")) {
            this.externalDiameter = this.castToQuantity(value);
        } else if (name.equals("shape")) {
            this.shape = this.castToString(value);
        } else if (name.equals("color")) {
            this.getColor().add(this.castToString(value));
        } else if (name.equals("imprint")) {
            this.getImprint().add(this.castToString(value));
        } else if (name.equals("image")) {
            this.getImage().add(this.castToAttachment(value));
        } else if (name.equals("scoring")) {
            this.scoring = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1221029593: {
                return this.getHeight();
            }
            case 113126854: {
                return this.getWidth();
            }
            case 95472323: {
                return this.getDepth();
            }
            case -791592328: {
                return this.getWeight();
            }
            case 1706919702: {
                return this.getNominalVolume();
            }
            case 161374584: {
                return this.getExternalDiameter();
            }
            case 109399969: {
                return this.getShapeElement();
            }
            case 94842723: {
                return this.addColorElement();
            }
            case 1926118409: {
                return this.addImprintElement();
            }
            case 100313435: {
                return this.addImage();
            }
            case 1924005583: {
                return this.getScoring();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1221029593: {
                return new String[]{"Quantity"};
            }
            case 113126854: {
                return new String[]{"Quantity"};
            }
            case 95472323: {
                return new String[]{"Quantity"};
            }
            case -791592328: {
                return new String[]{"Quantity"};
            }
            case 1706919702: {
                return new String[]{"Quantity"};
            }
            case 161374584: {
                return new String[]{"Quantity"};
            }
            case 109399969: {
                return new String[]{"string"};
            }
            case 94842723: {
                return new String[]{"string"};
            }
            case 1926118409: {
                return new String[]{"string"};
            }
            case 100313435: {
                return new String[]{"Attachment"};
            }
            case 1924005583: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("height")) {
            this.height = new Quantity();
            return this.height;
        }
        if (name.equals("width")) {
            this.width = new Quantity();
            return this.width;
        }
        if (name.equals("depth")) {
            this.depth = new Quantity();
            return this.depth;
        }
        if (name.equals("weight")) {
            this.weight = new Quantity();
            return this.weight;
        }
        if (name.equals("nominalVolume")) {
            this.nominalVolume = new Quantity();
            return this.nominalVolume;
        }
        if (name.equals("externalDiameter")) {
            this.externalDiameter = new Quantity();
            return this.externalDiameter;
        }
        if (name.equals("shape")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProdCharacteristic.shape");
        }
        if (name.equals("color")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProdCharacteristic.color");
        }
        if (name.equals("imprint")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProdCharacteristic.imprint");
        }
        if (name.equals("image")) {
            return this.addImage();
        }
        if (name.equals("scoring")) {
            this.scoring = new CodeableConcept();
            return this.scoring;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProdCharacteristic";
    }

    @Override
    public ProdCharacteristic copy() {
        ProdCharacteristic dst = new ProdCharacteristic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ProdCharacteristic dst) {
        super.copyValues(dst);
        dst.height = this.height == null ? null : this.height.copy();
        dst.width = this.width == null ? null : this.width.copy();
        dst.depth = this.depth == null ? null : this.depth.copy();
        dst.weight = this.weight == null ? null : this.weight.copy();
        dst.nominalVolume = this.nominalVolume == null ? null : this.nominalVolume.copy();
        dst.externalDiameter = this.externalDiameter == null ? null : this.externalDiameter.copy();
        StringType stringType = dst.shape = this.shape == null ? null : this.shape.copy();
        if (this.color != null) {
            dst.color = new ArrayList<StringType>();
            for (StringType stringType2 : this.color) {
                dst.color.add(stringType2.copy());
            }
        }
        if (this.imprint != null) {
            dst.imprint = new ArrayList<StringType>();
            for (StringType stringType3 : this.imprint) {
                dst.imprint.add(stringType3.copy());
            }
        }
        if (this.image != null) {
            dst.image = new ArrayList<Attachment>();
            for (Attachment attachment : this.image) {
                dst.image.add(attachment.copy());
            }
        }
        dst.scoring = this.scoring == null ? null : this.scoring.copy();
    }

    @Override
    protected ProdCharacteristic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProdCharacteristic)) {
            return false;
        }
        ProdCharacteristic o = (ProdCharacteristic)other_;
        return ProdCharacteristic.compareDeep(this.height, o.height, true) && ProdCharacteristic.compareDeep(this.width, o.width, true) && ProdCharacteristic.compareDeep(this.depth, o.depth, true) && ProdCharacteristic.compareDeep(this.weight, o.weight, true) && ProdCharacteristic.compareDeep(this.nominalVolume, o.nominalVolume, true) && ProdCharacteristic.compareDeep(this.externalDiameter, o.externalDiameter, true) && ProdCharacteristic.compareDeep(this.shape, o.shape, true) && ProdCharacteristic.compareDeep(this.color, o.color, true) && ProdCharacteristic.compareDeep(this.imprint, o.imprint, true) && ProdCharacteristic.compareDeep(this.image, o.image, true) && ProdCharacteristic.compareDeep(this.scoring, o.scoring, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProdCharacteristic)) {
            return false;
        }
        ProdCharacteristic o = (ProdCharacteristic)other_;
        return ProdCharacteristic.compareValues(this.shape, o.shape, true) && ProdCharacteristic.compareValues(this.color, o.color, true) && ProdCharacteristic.compareValues(this.imprint, o.imprint, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.height, this.width, this.depth, this.weight, this.nominalVolume, this.externalDiameter, this.shape, this.color, this.imprint, this.image, this.scoring});
    }
}

